/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@ThreadSafe
public class ElementStrippingStage
extends AbstractIteratingStage<Element> {
    @NonnullAfterInit
    @NotEmpty
    @GuardedBy(value="this")
    private String elementNamespace;
    @NonnullAfterInit
    @NotEmpty
    @GuardedBy(value="this")
    private String elementName;

    @Nullable
    public final synchronized String getElementNamespace() {
        return this.elementNamespace;
    }

    public synchronized void setElementNamespace(@Nonnull @NotEmpty String namespace) {
        this.checkSetterPreconditions();
        this.elementNamespace = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)namespace), (String)"target namespace can not be null or empty");
    }

    @Nullable
    public final synchronized String getElementName() {
        return this.elementName;
    }

    public synchronized void setElementName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.elementName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"target element name can not be null or empty");
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element docElement = item.unwrap();
        NodeList nodeList = docElement.getElementsByTagNameNS(this.getElementNamespace(), this.getElementName());
        int nNodes = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(nNodes);
        for (int eIndex = 0; eIndex < nNodes; ++eIndex) {
            elements.add((Element)nodeList.item(eIndex));
        }
        for (Element element : elements) {
            element.getParentNode().removeChild(element);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.elementNamespace == null) {
            throw new ComponentInitializationException("target namespace can not be null or empty");
        }
        if (this.elementName == null) {
            throw new ComponentInitializationException("target element name can not be null or empty");
        }
    }
}

