/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.expression;

import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.expression.AbstractSpringExpressionEvaluator;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionBiFunction<T, U, V>
extends AbstractSpringExpressionEvaluator
implements BiFunction<T, U, V> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionBiFunction.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    public SpringExpressionBiFunction(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    @Override
    public void setOutputType(@Nullable Class<?> type) {
        super.setOutputType(type);
    }

    @Override
    public void setReturnOnError(@Nullable Object value) {
        super.setReturnOnError(value);
    }

    @Override
    @Nullable
    public V apply(@Nullable T first, @Nullable U second) {
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            Class intype1 = (Class)types.getFirst();
            Class intype2 = (Class)types.getSecond();
            if (null != first && null != intype1 && !intype1.isInstance(first)) {
                this.log.error("Input of type {} was not of type {}", first.getClass(), (Object)intype1);
                return (V)this.getReturnOnError();
            }
            if (null != second && null != intype2 && !intype2.isInstance(second)) {
                this.log.error("Input of type {} was not of type {}", second.getClass(), (Object)intype2);
                return (V)this.getReturnOnError();
            }
        }
        return (V)this.evaluate(first, second);
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input1", input != null ? input[0] : null);
        context.setVariable("input2", input != null ? input[1] : null);
    }
}

