/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.custom;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;

public class AbstractCustomBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    @Nonnull
    @NotEmpty
    public static final String CUSTOM_PARSER_PROPERTIES_LOCATION = "META-INF/net/shibboleth/spring/parser.properties";
    @Nullable
    private static Properties customProperties;
    @Nonnull
    private static final Logger LOG;

    protected void registerBeanDefinition(@Nonnull BeanDefinitionHolder definition, @Nonnull BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(definition.getBeanName())) {
            String claz = definition.getBeanDefinition().getBeanClassName();
            LOG.warn("Duplicate Definition '{}' of type '{}'", (Object)definition.getBeanName(), (Object)claz);
        }
        super.registerBeanDefinition(definition, registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getCustomProperty(@Nonnull String name, @Nullable String defaultValue) {
        Class<AbstractCustomBeanDefinitionParser> clazz = AbstractCustomBeanDefinitionParser.class;
        synchronized (AbstractCustomBeanDefinitionParser.class) {
            if (customProperties == null) {
                Properties props = new Properties();
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(CUSTOM_PARSER_PROPERTIES_LOCATION);){
                    if (is != null) {
                        props.load(is);
                    } else {
                        LOG.debug("No custom Spring parser configuration properties loaded from {}", (Object)CUSTOM_PARSER_PROPERTIES_LOCATION);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Problem attempting to load custom Spring parser configuration properties 'META-INF/net/shibboleth/spring/parser.properties' from classpath", (Throwable)e);
                }
                finally {
                    customProperties = props;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            assert (customProperties != null);
            return customProperties.getProperty(name, defaultValue);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(AbstractCustomBeanDefinitionParser.class);
    }
}

