/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet.impl;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.shared.servlet.AbstractConditionalFilter;
import net.shibboleth.shared.servlet.impl.HttpServletRequestResponseContext;
import net.shibboleth.shared.spring.servlet.ChainableFilter;

public class RequestResponseContextFilter
extends AbstractConditionalFilter
implements ChainableFilter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    @Override
    public int getOrder() {
        return ChainableFilter.FilterOrder.LATEST.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Request is not an instance of HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Response is not an instance of HttpServletResponse");
        }
        try {
            HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response));
            chain.doFilter(request, response);
        }
        finally {
            HttpServletRequestResponseContext.clearCurrent();
        }
    }
}

