/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.validate.x509.AbstractX509Validator;

@ThreadSafe
public class X509RSAKeyLengthValidator
extends AbstractX509Validator {
    @GuardedBy(value="this")
    private int errorBoundary = 2048;
    @GuardedBy(value="this")
    private int warningBoundary;

    public final synchronized int getErrorBoundary() {
        return this.errorBoundary;
    }

    public synchronized void setErrorBoundary(int length) {
        this.errorBoundary = length;
    }

    public final synchronized int getWarningBoundary() {
        return this.warningBoundary;
    }

    public synchronized void setWarningBoundary(int length) {
        this.warningBoundary = length;
    }

    @Override
    public void doValidate(@Nonnull X509Certificate cert, @Nonnull Item<?> item, @Nonnull String callerId) {
        PublicKey key = cert.getPublicKey();
        if ("RSA".equals(key.getAlgorithm())) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            int keyLen = rsaKey.getModulus().bitLength();
            if (keyLen < this.getErrorBoundary()) {
                this.addError("RSA key length of " + keyLen + " bits is less than required " + this.getErrorBoundary(), item, callerId);
            } else if (keyLen < this.getWarningBoundary()) {
                this.addWarning("RSA key length of " + keyLen + " bits is less than recommended " + this.getWarningBoundary(), item, callerId);
            }
        }
    }
}

