/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.BaseValidator;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;

@ThreadSafe
public class ValidatorSequence<V>
extends BaseValidator
implements Validator<V> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private List<Validator<V>> validators = CollectionSupport.emptyList();

    public synchronized void setValidators(@Nonnull @NonnullElements @Unmodifiable List<Validator<V>> newValidators) {
        this.checkSetterPreconditions();
        this.validators = CollectionSupport.copyToList(newValidators);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized List<Validator<V>> getValidators() {
        return this.validators;
    }

    @Override
    @Nonnull
    public Validator.Action validate(@Nonnull V value, @Nonnull Item<?> item, @Nonnull String callerId, @Nullable String valueContext) throws StageProcessingException {
        for (Validator<V> validator : this.getValidators()) {
            Validator.Action action = validator.validate(value, item, callerId, valueContext);
            if (action != Validator.Action.DONE) continue;
            return action;
        }
        return Validator.Action.CONTINUE;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        for (Validator<V> validator : this.getValidators()) {
            if (validator.isInitialized()) continue;
            validator.initialize();
        }
    }
}

