/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.scripting.EvaluableScript;

@ThreadSafe
public class ScriptletStage<T>
extends AbstractStage<T> {
    @Nonnull
    @GuardedBy(value="this")
    @NotEmpty
    private String variableName = "items";
    @NonnullAfterInit
    @GuardedBy(value="this")
    private EvaluableScript script;

    public final synchronized String getVariableName() {
        return this.variableName;
    }

    public final synchronized void setVariableName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.variableName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"variable name may not be null or empty");
    }

    @NonnullAfterInit
    public final synchronized EvaluableScript getScript() {
        return this.script;
    }

    public synchronized void setScript(@Nonnull EvaluableScript stageScript) {
        this.checkSetterPreconditions();
        this.script = (EvaluableScript)Constraint.isNotNull((Object)stageScript, (String)"Stage script can not be null");
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setAttribute(this.getVariableName(), items, 100);
        try {
            this.getScript().eval((ScriptContext)context);
        }
        catch (ScriptException e) {
            throw new StageProcessingException("unable to execute script", e);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.script == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", script may not be null");
        }
    }
}

