/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class MultiOutputSerializationStage<T>
extends AbstractIteratingStage<T> {
    @NonnullAfterInit
    @GuardedBy(value="this")
    private OutputStrategy<T> outputStrategy;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private ItemSerializer<T> serializer;

    @NonnullAfterInit
    public final synchronized OutputStrategy<T> getOutputStrategy() {
        return this.outputStrategy;
    }

    public synchronized void setOutputStrategy(@Nonnull OutputStrategy<T> strategy) {
        this.checkSetterPreconditions();
        this.outputStrategy = (OutputStrategy)Constraint.isNotNull(strategy, (String)"Output strategy can not be null");
    }

    @NonnullAfterInit
    public final synchronized ItemSerializer<T> getSerializer() {
        return this.serializer;
    }

    public synchronized void setSerializer(@Nonnull ItemSerializer<T> itemSerializer) {
        this.checkSetterPreconditions();
        this.serializer = (ItemSerializer)Constraint.isNotNull(itemSerializer, (String)"Item serializer can not be null");
    }

    @Override
    protected void doExecute(@Nonnull Item<T> item) throws StageProcessingException {
        try (Destination destination = this.getOutputStrategy().getDestination(item);
             OutputStream stream = destination.getOutputStream();){
            this.getSerializer().serialize(item, stream);
        }
        catch (IOException e) {
            throw new StageProcessingException("Error writing to output location", e);
        }
    }

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.outputStrategy == null) {
            throw new ComponentInitializationException("Output strategy can not be null");
        }
        if (this.serializer == null) {
            throw new ComponentInitializationException("Item collection serializer can not be null");
        }
    }

    public static interface OutputStrategy<T> {
        @Nonnull
        public Destination getDestination(@Nonnull Item<T> var1) throws StageProcessingException;
    }

    public static interface Destination
    extends Closeable {
        @Nonnull
        public OutputStream getOutputStream() throws IOException;
    }
}

