/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public abstract class AbstractStage<T>
extends AbstractIdentifiableInitializableComponent
implements Stage<T> {
    @Nonnull
    @GuardedBy(value="this")
    private Predicate<Collection<Item<T>>> collectionPredicate = x -> true;

    public synchronized void setCollectionPredicate(@Nonnull Predicate<Collection<Item<T>>> pred) {
        this.checkSetterPreconditions();
        this.collectionPredicate = (Predicate)Constraint.isNotNull(pred, (String)"collectionPredicate may not be null");
    }

    @Nonnull
    public final synchronized Predicate<Collection<Item<T>>> getCollectionPredicate() {
        return this.collectionPredicate;
    }

    @Override
    public void execute(@Nonnull @NonnullElements List<Item<T>> items) throws StageProcessingException {
        this.checkComponentActive();
        if (this.getCollectionPredicate().test(items)) {
            this.doExecute(items);
        }
    }

    protected abstract void doExecute(@Nonnull @NonnullElements List<Item<T>> var1) throws StageProcessingException;
}

