/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdrpi;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.mdrpi.MDRPIMetadataSupport;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthority;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.collection.ClassToInstanceMultiMap;
import net.shibboleth.shared.xml.AttributeSupport;
import org.w3c.dom.Element;

@ThreadSafe
public class RegistrationAuthorityPopulationStage
extends AbstractIteratingStage<Element> {
    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element entity = item.unwrap();
        ClassToInstanceMultiMap<ItemMetadata> metadata = item.getItemMetadata();
        if (!SAMLMetadataSupport.isEntityDescriptor(entity)) {
            metadata.put((Object)new ErrorStatus(this.ensureId(), "item was not an EntityDescriptor"));
        } else {
            Element regInfo = SAMLMetadataSupport.getDescriptorExtension(entity, MDRPIMetadataSupport.MDRPI_REGISTRATION_INFO);
            if (regInfo != null) {
                String attr = AttributeSupport.getAttributeValue((Element)regInfo, null, (String)"registrationAuthority");
                if (attr == null) {
                    String eid = SAMLMetadataSupport.getEntityID(entity);
                    metadata.put((Object)new ErrorStatus(this.ensureId(), "RegistrationInfo for " + eid + " did not have a registrationAuthority attribute"));
                } else {
                    metadata.put((Object)new RegistrationAuthority(attr));
                }
            }
        }
    }
}

