/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdrpi;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.mdrpi.MDRPIMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractFilteringStage;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntityRegistrationAuthorityFilterStage
extends AbstractFilteringStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(EntityRegistrationAuthorityFilterStage.class);
    @GuardedBy(value="this")
    private boolean requiringRegistrationInformation;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<String> designatedAuthorities = CollectionSupport.emptySet();
    @GuardedBy(value="this")
    private boolean keepingAuthorities;
    @GuardedBy(value="this")
    private boolean removingEntitylessEntitiesDescriptor = true;

    public final synchronized boolean isRequiringRegistrationInformation() {
        return this.requiringRegistrationInformation;
    }

    public synchronized void setRequiringRegistrationInformation(boolean isRequired) {
        this.checkSetterPreconditions();
        this.requiringRegistrationInformation = isRequired;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<String> getDesignatedRegistrationAuthorities() {
        return this.designatedAuthorities;
    }

    public synchronized void setDesignatedRegistrationAuthorities(@Nonnull @NonnullElements @Unmodifiable Collection<String> authorities) {
        this.checkSetterPreconditions();
        this.designatedAuthorities = CollectionSupport.copyToSet(authorities);
    }

    public final synchronized boolean isKeepingRegistrationAuthorities() {
        return this.keepingAuthorities;
    }

    public synchronized void setKeepingRegistrationAuthorities(boolean keeping) {
        this.checkSetterPreconditions();
        this.keepingAuthorities = keeping;
    }

    public final synchronized boolean isRemovingEntitylessEntitiesDescriptor() {
        return this.removingEntitylessEntitiesDescriptor;
    }

    public synchronized void setRemovingEntitylessEntitiesDescriptor(boolean remove) {
        this.checkSetterPreconditions();
        this.removingEntitylessEntitiesDescriptor = remove;
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntitiesDescriptor(descriptor)) {
            if (this.processEntitiesDescriptor(descriptor)) {
                return false;
            }
        } else if (SAMLMetadataSupport.isEntityDescriptor(descriptor)) {
            return !this.filterOutDescriptor(descriptor);
        }
        return true;
    }

    protected boolean processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        boolean remove = true;
        if (this.filterOutDescriptor(entitiesDescriptor)) {
            return true;
        }
        List childEntitiesDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        for (Element descriptor : childEntitiesDescriptors) {
            assert (descriptor != null);
            if (this.processEntitiesDescriptor(descriptor)) {
                entitiesDescriptor.removeChild(descriptor);
                continue;
            }
            remove = false;
        }
        List childEntityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        for (Element descriptor : childEntityDescriptors) {
            assert (descriptor != null);
            if (this.filterOutDescriptor(descriptor)) {
                entitiesDescriptor.removeChild(descriptor);
                continue;
            }
            remove = false;
        }
        return remove && this.isRemovingEntitylessEntitiesDescriptor();
    }

    protected boolean filterOutDescriptor(@Nonnull Element descriptor) {
        Element registrationInfoElement = SAMLMetadataSupport.getDescriptorExtension(descriptor, MDRPIMetadataSupport.MDRPI_REGISTRATION_INFO);
        if (registrationInfoElement == null) {
            if (this.isRequiringRegistrationInformation()) {
                LOG.debug("{} pipeline stage removing Item because it did not have required registration information extension", (Object)this.getId());
                return true;
            }
            return false;
        }
        String registrationAuthority = AttributeSupport.getAttributeValue((Element)registrationInfoElement, null, (String)"registrationAuthority");
        if (registrationAuthority == null) {
            LOG.debug("{} pipeline stage removing Item because it contained a registration info extension but no authority attribute", (Object)this.getId());
            return true;
        }
        if (this.isKeepingRegistrationAuthorities() && !this.getDesignatedRegistrationAuthorities().contains(registrationAuthority)) {
            LOG.debug("{} pipeline stage removing Item because its registration authority was not on the list", (Object)this.getId());
            return true;
        }
        if (!this.isKeepingRegistrationAuthorities() && this.getDesignatedRegistrationAuthorities().contains(registrationAuthority)) {
            LOG.debug("{} pipeline stage removing Item because its registration authority was on the list", (Object)this.getId());
            return true;
        }
        return false;
    }
}

