/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.dom.saml.mdattr.AbstractEntityAttributeMatcher;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class MultiPredicateMatcher
extends AbstractEntityAttributeMatcher {
    @Nonnull
    @GuardedBy(value="this")
    private Predicate<CharSequence> valuePredicate = x -> true;
    @Nonnull
    @GuardedBy(value="this")
    private Predicate<CharSequence> namePredicate = x -> true;
    @Nonnull
    @GuardedBy(value="this")
    private Predicate<CharSequence> nameFormatPredicate = x -> true;
    @Nonnull
    @GuardedBy(value="this")
    private Predicate<CharSequence> registrationAuthorityPredicate = x -> true;

    @Nonnull
    public final synchronized Predicate<CharSequence> getValuePredicate() {
        return this.valuePredicate;
    }

    public synchronized void setValuePredicate(@Nonnull Predicate<CharSequence> predicate) {
        this.valuePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"value predicate may not be null");
    }

    @Nonnull
    public final synchronized Predicate<CharSequence> getNamePredicate() {
        return this.namePredicate;
    }

    public synchronized void setNamePredicate(@Nonnull Predicate<CharSequence> predicate) {
        this.namePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"name predicate may not be null");
    }

    @Nonnull
    public final synchronized Predicate<CharSequence> getNameFormatPredicate() {
        return this.nameFormatPredicate;
    }

    public synchronized void setNameFormatPredicate(@Nonnull Predicate<CharSequence> predicate) {
        this.nameFormatPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"name format predicate may not be null");
    }

    @Nonnull
    public final synchronized Predicate<CharSequence> getRegistrationAuthorityPredicate() {
        return this.registrationAuthorityPredicate;
    }

    public synchronized void setRegistrationAuthorityPredicate(@Nonnull Predicate<CharSequence> predicate) {
        this.registrationAuthorityPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"registration authority predicate may not be null");
    }

    @Override
    protected boolean matchAttributeValue(@Nonnull String inputValue) {
        return this.getValuePredicate().test(inputValue);
    }

    @Override
    protected boolean matchAttributeName(@Nonnull String inputName) {
        return this.getNamePredicate().test(inputName);
    }

    @Override
    protected boolean matchAttributeNameFormat(@Nonnull String inputNameFormat) {
        return this.getNameFormatPredicate().test(inputNameFormat);
    }

    @Override
    protected boolean matchRegistrationAuthority(@Nullable String inputRegistrationAuthority) {
        return this.getRegistrationAuthorityPredicate().test(inputRegistrationAuthority);
    }
}

