/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractFilteringStage;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class EntityFilterStage
extends AbstractFilteringStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(EntityFilterStage.class);
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<String> designatedEntities = CollectionSupport.emptySet();
    @GuardedBy(value="this")
    private boolean keepingEntities;
    @GuardedBy(value="this")
    private boolean removingEntitylessEntitiesDescriptor = true;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<String> getDesignatedEntities() {
        return this.designatedEntities;
    }

    public synchronized void setDesignatedEntities(@Nonnull @NonnullElements @Unmodifiable Collection<String> ids) {
        this.checkSetterPreconditions();
        this.designatedEntities = CollectionSupport.copyToSet(ids);
    }

    public final synchronized boolean isKeepingEntities() {
        return this.keepingEntities;
    }

    public synchronized void setKeepingEntities(boolean keeping) {
        this.checkSetterPreconditions();
        this.keepingEntities = keeping;
    }

    public final synchronized boolean isRemovingEntitylessEntitiesDescriptor() {
        return this.removingEntitylessEntitiesDescriptor;
    }

    public synchronized void setRemovingEntitylessEntitiesDescriptor(boolean remove) {
        this.checkSetterPreconditions();
        this.removingEntitylessEntitiesDescriptor = remove;
    }

    @Override
    protected boolean doExecute(@Nonnull Item<Element> item) {
        Element descriptor = item.unwrap();
        return !(SAMLMetadataSupport.isEntitiesDescriptor(descriptor) ? this.processEntitiesDescriptor(descriptor) : SAMLMetadataSupport.isEntityDescriptor(descriptor) && this.processEntityDescriptor(descriptor));
    }

    protected boolean processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        boolean remove = true;
        List childEntitiesDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITIES_DESCRIPTOR_NAME);
        for (Element descriptor : childEntitiesDescriptors) {
            assert (descriptor != null);
            if (this.processEntitiesDescriptor(descriptor)) {
                entitiesDescriptor.removeChild(descriptor);
                continue;
            }
            remove = false;
        }
        List childEntityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        for (Element descriptor : childEntityDescriptors) {
            assert (descriptor != null);
            if (this.processEntityDescriptor(descriptor)) {
                entitiesDescriptor.removeChild(descriptor);
                continue;
            }
            remove = false;
        }
        return remove && this.isRemovingEntitylessEntitiesDescriptor();
    }

    protected boolean processEntityDescriptor(@Nonnull Element entityDescriptor) {
        String entityId = SAMLMetadataSupport.getEntityID(entityDescriptor);
        if (this.isKeepingEntities() && !this.getDesignatedEntities().contains(entityId)) {
            LOG.debug("{} pipeline stage removing entity {} because it wasn't in the list", (Object)this.getId(), (Object)entityId);
            return true;
        }
        if (!this.isKeepingEntities() && this.getDesignatedEntities().contains(entityId)) {
            LOG.debug("{} pipeline stage removing entity {} because it was on the list", (Object)this.getId(), (Object)entityId);
            return true;
        }
        return false;
    }
}

