/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.AbstractIteratingStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class ContactPersonFilterStage
extends AbstractIteratingStage<Element> {
    public static final String TECHNICAL = "technical";
    public static final String SUPPORT = "support";
    public static final String ADMINISTRATIVE = "administrative";
    public static final String BILLING = "billing";
    public static final String OTHER = "other";
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private static final Set<String> ALLOWED_TYPES = CollectionSupport.setOf((Object[])new String[]{"technical", "support", "administrative", "billing", "other"});
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ContactPersonFilterStage.class);
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<String> designatedTypes = CollectionSupport.copyToSet(ALLOWED_TYPES);
    @GuardedBy(value="this")
    private boolean keepingTypes = true;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<String> getDesignatedTypes() {
        return this.designatedTypes;
    }

    public synchronized void setDesignatedTypes(@Nonnull @NonnullElements @Unmodifiable Collection<String> types) {
        this.checkSetterPreconditions();
        HashSet<String> checkedTypes = new HashSet<String>();
        for (String type : types) {
            if (ALLOWED_TYPES.contains(type)) {
                checkedTypes.add(type);
                continue;
            }
            LOG.debug("Stage {}: {} is not an allowed contact person type and so has been ignored", (Object)this.getId(), (Object)type);
        }
        this.designatedTypes = CollectionSupport.copyToSet(checkedTypes);
    }

    public final synchronized boolean isKeepingTypes() {
        return this.keepingTypes;
    }

    public synchronized void setKeepingTypes(boolean keeping) {
        this.checkSetterPreconditions();
        this.keepingTypes = keeping;
    }

    @Override
    protected void doExecute(@Nonnull Item<Element> item) throws StageProcessingException {
        Element descriptor = item.unwrap();
        if (SAMLMetadataSupport.isEntitiesDescriptor(descriptor)) {
            this.processEntitiesDescriptor(descriptor);
        } else if (SAMLMetadataSupport.isEntityDescriptor(descriptor)) {
            this.processEntityDescriptor(descriptor);
        }
    }

    protected void processEntitiesDescriptor(@Nonnull Element entitiesDescriptor) {
        List children = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element child : children) {
            assert (child != null);
            if (SAMLMetadataSupport.isEntitiesDescriptor(child)) {
                this.processEntitiesDescriptor(child);
                continue;
            }
            if (!SAMLMetadataSupport.isEntityDescriptor(child)) continue;
            this.processEntityDescriptor(child);
        }
    }

    protected void processEntityDescriptor(@Nonnull Element entityDescriptor) {
        String entityId = SAMLMetadataSupport.getEntityID(entityDescriptor);
        List contactPersons = ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"ContactPerson");
        if (!contactPersons.isEmpty()) {
            LOG.debug("{} pipeline stage filtering ContactPerson from EntityDescriptor {}", (Object)this.getId(), (Object)entityId);
            for (Element contactPerson : contactPersons) {
                assert (contactPerson != null);
                if (this.isRetainedContactPersonType(contactPerson)) continue;
                entityDescriptor.removeChild(contactPerson);
            }
        }
    }

    protected boolean isRetainedContactPersonType(@Nonnull Element contactPerson) {
        Constraint.isNotNull((Object)contactPerson, (String)"Contact person element can not be null");
        String type = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)contactPerson, null, (String)"contactType"));
        if (type == null) {
            LOG.debug("The following ContactPerson does not contain the required contactType attribute, it will be removed:\n{}", (Object)SerializeSupport.prettyPrintXML((Node)contactPerson));
            return false;
        }
        if (!ALLOWED_TYPES.contains(type)) {
            LOG.debug("The following ContactPerson contained an invalid contactType, it will be removed:\n{}", (Object)SerializeSupport.prettyPrintXML((Node)contactPerson));
            return false;
        }
        if (this.isKeepingTypes() && this.getDesignatedTypes().contains(type)) {
            return true;
        }
        return !this.isKeepingTypes() && !this.getDesignatedTypes().contains(type);
    }
}

