/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.impl;

import java.security.Key;
import java.security.PublicKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.ds.XMLDSIGSupport;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.reference.ReferenceData;
import org.apache.xml.security.signature.reference.ReferenceSubTreeData;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLSignatureValidator {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(XMLSignatureValidator.class);
    private final PublicKey verificationKey;
    private final Set<String> disallowedDigests;
    private final Set<String> disallowedSignatureMethods;
    private final boolean emptyReferencePermitted;

    public XMLSignatureValidator(@Nonnull PublicKey key, @Nullable Set<String> disallowDigests, @Nullable Set<String> disallowSignatureMethods, boolean emptyRefPermitted) {
        Constraint.isNotNull((Object)key, (String)"public key can not be null");
        this.verificationKey = key;
        this.disallowedDigests = disallowDigests != null ? new HashSet<String>(disallowDigests) : Collections.emptySet();
        this.disallowedSignatureMethods = disallowSignatureMethods != null ? new HashSet<String>(disallowSignatureMethods) : Collections.emptySet();
        this.emptyReferencePermitted = emptyRefPermitted;
    }

    private void markIdAttribute(@Nonnull Element docElement, @Nonnull Reference reference) throws ValidationException {
        String referenceURI = reference.getURI();
        if (referenceURI.isEmpty()) {
            LOG.debug("reference was empty; no ID marking required");
            return;
        }
        if (AttributeSupport.getIdAttribute((Element)docElement) != null) {
            LOG.debug("document element already has an ID attribute");
            return;
        }
        if (!referenceURI.startsWith("#")) {
            throw new ValidationException("Signature Reference URI was not a document fragment reference: " + referenceURI);
        }
        String id = referenceURI.substring(1);
        NamedNodeMap attributes = docElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!id.equals(attribute.getValue())) continue;
            LOG.debug("marking ID attribute {}", (Object)attribute.getName());
            docElement.setIdAttributeNode(attribute, true);
            return;
        }
        LOG.debug("did not find a document element attribute with value '{}'", (Object)id);
    }

    public void verifySignature(@Nonnull Element docElement, @Nonnull Element signatureElement) throws ValidationException {
        String alg;
        LOG.debug("Creating XML security library XMLSignature object");
        XMLSignature signature = null;
        try {
            signature = new XMLSignature(signatureElement, "");
        }
        catch (XMLSecurityException e) {
            throw new ValidationException("Unable to read XML signature", (Exception)((Object)e));
        }
        if (signature.getObjectLength() != 0) {
            throw new ValidationException("Signature contained an Object element, this is not allowed");
        }
        Reference ref = this.extractReference(signature);
        this.markIdAttribute(docElement, ref);
        try {
            alg = ref.getMessageDigestAlgorithm().getAlgorithmURI();
            LOG.debug("checking whether digest {} is allowed", (Object)alg);
            if (this.disallowedDigests.contains(alg)) {
                throw new ValidationException("Digest algorithm " + alg + " is disallowed");
            }
        }
        catch (XMLSignatureException e) {
            throw new ValidationException("unable to retrieve signature digest algorithm");
        }
        alg = signature.getSignedInfo().getSignatureMethodURI();
        LOG.debug("checking whether signature method {} is allowed", (Object)alg);
        if (this.disallowedSignatureMethods.contains(alg)) {
            throw new ValidationException("Signature algorithm " + alg + " is disallowed");
        }
        if (LOG.isDebugEnabled()) {
            try {
                byte[] bytes = this.verificationKey.getEncoded();
                assert (bytes != null);
                LOG.debug("Verifying XML signature with key\n{}", (Object)Base64Support.encode((byte[])bytes, (boolean)false));
            }
            catch (EncodingException bytes) {
                // empty catch block
            }
        }
        try {
            if (!signature.checkSignatureValue((Key)this.verificationKey)) {
                throw new ValidationException("XML document signature verification failed");
            }
            this.validateSignatureReference(docElement, this.extractReference(signature));
            LOG.debug("XML document signature verified.");
        }
        catch (XMLSignatureException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to validate signature", (Throwable)e);
            }
            throw new ValidationException("XML document signature verification failed with an error: " + e.getMessage());
        }
    }

    @Nonnull
    private Reference extractReference(@Nonnull XMLSignature signature) throws ValidationException {
        int numReferences = signature.getSignedInfo().getLength();
        if (numReferences != 1) {
            throw new ValidationException("Signature SignedInfo had invalid number of References: " + numReferences);
        }
        try {
            Reference ref = signature.getSignedInfo().item(0);
            if (ref == null) {
                throw new ValidationException("Signature Reference was null");
            }
            if (!this.emptyReferencePermitted && ref.getURI().isEmpty()) {
                throw new ValidationException("empty references are not permitted");
            }
            return ref;
        }
        catch (XMLSecurityException e) {
            throw new ValidationException("Apache XML Security exception obtaining Reference: " + e.getMessage());
        }
    }

    private void validateSignatureReference(@Nonnull Element docElement, @Nonnull Reference ref) throws ValidationException {
        this.validateSignatureReferenceUri(docElement, ref);
        this.validateSignatureTransforms(ref);
    }

    private void validateSignatureReferenceUri(@Nonnull Element expectedSignedNode, @Nonnull Reference reference) throws ValidationException {
        ReferenceData refData = reference.getReferenceData();
        if (refData instanceof ReferenceSubTreeData) {
            Node root;
            ReferenceSubTreeData subTree = (ReferenceSubTreeData)refData;
            Node resolvedSignedNode = root = subTree.getRoot();
            if (root.getNodeType() == 9) {
                resolvedSignedNode = ((Document)root).getDocumentElement();
            }
            if (!expectedSignedNode.isSameNode(resolvedSignedNode)) {
                throw new ValidationException("Signature Reference URI \"" + reference.getURI() + "\" was resolved to a node other than the document element");
            }
        } else {
            throw new ValidationException("Signature Reference URI did not resolve to a subtree");
        }
    }

    private void validateSignatureTransforms(@Nonnull Reference reference) throws ValidationException {
        Transforms transforms = null;
        try {
            transforms = reference.getTransforms();
        }
        catch (XMLSecurityException e) {
            throw new ValidationException("Apache XML Security error obtaining Transforms instance: " + e.getMessage());
        }
        if (transforms == null) {
            throw new ValidationException("Error obtaining Transforms instance, null was returned");
        }
        int numTransforms = transforms.getLength();
        if (numTransforms > 2) {
            throw new ValidationException("Invalid number of Transforms was present: " + numTransforms);
        }
        boolean sawEnveloped = false;
        for (int i = 0; i < numTransforms; ++i) {
            Transform transform = null;
            try {
                transform = transforms.item(i);
            }
            catch (TransformationException e) {
                throw new ValidationException("Error obtaining transform instance: " + e.getMessage());
            }
            String uri = transform.getURI();
            if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(uri)) {
                LOG.debug("Saw Enveloped signature transform");
                sawEnveloped = true;
                continue;
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(uri) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(uri)) {
                LOG.debug("Saw Exclusive C14N signature transform");
                continue;
            }
            throw new ValidationException("Saw invalid signature transform: " + uri);
        }
        if (!sawEnveloped) {
            throw new ValidationException("Signature was missing the required Enveloped signature transform");
        }
    }

    @Nullable
    public Element getSignatureElement(@Nonnull Element docElement) throws ValidationException {
        List sigElements = ElementSupport.getChildElements((Node)docElement, (QName)XMLDSIGSupport.SIGNATURE_NAME);
        if (sigElements.isEmpty()) {
            return null;
        }
        if (sigElements.size() > 1) {
            throw new ValidationException("XML document contained more than one signature, unable to process");
        }
        return (Element)sigElements.get(0);
    }

    public static class ValidationException
    extends Exception {
        private static final long serialVersionUID = -6649552572123849961L;

        public ValidationException(@Nullable String message) {
            super(message);
        }

        public ValidationException(@Nullable String message, @Nullable Exception wrappedException) {
            super(message, wrappedException);
        }
    }
}

