/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.metadata.AbstractItem;
import net.shibboleth.metadata.Item;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.xml.ElementSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@NotThreadSafe
public class DOMElementItem
extends AbstractItem<Element> {
    public DOMElementItem(@Nonnull Document document) {
        super(DOMElementItem.processDocument(document));
    }

    public DOMElementItem(@Nonnull Element element) {
        super(DOMElementItem.processElement(element));
    }

    @Nonnull
    private static Element processDocument(@Nonnull Document document) {
        Constraint.isNotNull((Object)document, (String)"DOM Document can not be null");
        Element docElement = (Element)Constraint.isNotNull((Object)document.getDocumentElement(), (String)"DOM Document Element may not be null");
        return docElement;
    }

    @Nonnull
    private static Element processElement(@Nonnull Element element) {
        Constraint.isNotNull((Object)element, (String)"DOM Document Element may not be null");
        DOMImplementation domImpl = element.getOwnerDocument().getImplementation();
        Document newDocument = domImpl.createDocument(null, null, null);
        Element newDocumentRoot = (Element)newDocument.importNode(element, true);
        assert (newDocumentRoot != null);
        ElementSupport.setDocumentElement((Document)newDocument, (Element)newDocumentRoot);
        return newDocumentRoot;
    }

    @Override
    @Nonnull
    public Item<Element> copy() {
        DOMElementItem clone = new DOMElementItem((Element)this.unwrap());
        clone.getItemMetadata().putAll(this.getItemMetadata());
        return clone;
    }
}

