/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.pipeline.AbstractStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;

@ThreadSafe
public abstract class AbstractXSLProcessingStage
extends AbstractStage<Element> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXSLProcessingStage.class);
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Resource xslResource;
    @NonnullAfterInit
    @GuardedBy(value="this")
    private Templates xslTemplate;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Map<String, Object> transformAttributes = CollectionSupport.emptyMap();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Map<String, Boolean> transformFeatures = CollectionSupport.emptyMap();
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Map<String, Object> transformParameters = CollectionSupport.emptyMap();
    @Nullable
    @GuardedBy(value="this")
    private URIResolver uriResolver;

    @Nullable
    public final synchronized Resource getXSLResource() {
        return this.xslResource;
    }

    public synchronized void setXSLResource(@Nonnull Resource resource) {
        this.checkSetterPreconditions();
        this.xslResource = (Resource)Constraint.isNotNull((Object)resource, (String)"XSL resource can not be null");
    }

    @NonnullAfterInit
    private synchronized Templates getXSLTemplate() {
        return this.xslTemplate;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Map<String, Object> getTransformAttributes() {
        return this.transformAttributes;
    }

    public synchronized void setTransformAttributes(@Nonnull @NonnullElements @Unmodifiable Map<String, Object> attributes) {
        this.checkSetterPreconditions();
        this.transformAttributes = CollectionSupport.copyToMap(attributes);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Map<String, Boolean> getTransformFeatures() {
        return this.transformFeatures;
    }

    public synchronized void setTransformFeatures(@Nonnull @NonnullElements @Unmodifiable Map<String, Boolean> features) {
        this.checkSetterPreconditions();
        this.transformFeatures = CollectionSupport.copyToMap(features);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Map<String, Object> getTransformParameters() {
        return this.transformParameters;
    }

    public synchronized void setTransformParameters(@Nonnull @NonnullElements @Unmodifiable Map<String, Object> parameters) {
        this.checkSetterPreconditions();
        this.transformParameters = CollectionSupport.copyToMap(parameters);
    }

    @Nullable
    public final synchronized URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public synchronized void setURIResolver(@Nullable URIResolver resolver) {
        this.checkSetterPreconditions();
        this.uriResolver = resolver;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements List<Item<Element>> items) throws StageProcessingException {
        try {
            Transformer transformer = this.getXSLTemplate().newTransformer();
            assert (transformer != null);
            for (Map.Entry<String, Object> entry : this.getTransformParameters().entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            this.executeTransformer(transformer, items);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("XSL transformation engine misconfigured", e);
        }
    }

    protected abstract void executeTransformer(@Nonnull Transformer var1, @Nonnull @NonnullElements Collection<Item<Element>> var2) throws StageProcessingException, TransformerConfigurationException;

    protected synchronized void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.xslResource == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", XslResource must not be null");
        }
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            for (Map.Entry<String, Object> entry : this.transformAttributes.entrySet()) {
                tfactory.setAttribute(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.transformFeatures.entrySet()) {
                tfactory.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            if (this.uriResolver != null) {
                tfactory.setURIResolver(this.uriResolver);
            }
            LOG.debug("{} pipeline stage compiling XSL file {}", (Object)this.getId(), (Object)this.xslResource);
            this.xslTemplate = tfactory.newTemplates(new StreamSource(this.xslResource.getInputStream(), this.xslResource.getURL().toExternalForm()));
        }
        catch (TransformerConfigurationException e) {
            throw new ComponentInitializationException("XSL transformation engine misconfigured", (Exception)e);
        }
        catch (IOException e) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", error reading XslResource " + this.xslResource.getDescription() + " information", (Exception)e);
        }
    }

    @Immutable
    public class StatusInfoAppendingErrorListener
    implements ErrorListener {
        public static final String ERROR_PREFIX = "[ERROR]";
        public static final String WARN_PREFIX = "[WARN]";
        public static final String INFO_PREFIX = "[INFO]";
        private final Item<?> item;

        public StatusInfoAppendingErrorListener(Item<?> receivingItem) {
            this.item = receivingItem;
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            assert (e != null);
            this.parseAndAppendStatusInfo(e);
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            assert (e != null);
            this.parseAndAppendStatusInfo(e);
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            assert (e != null);
            this.parseAndAppendStatusInfo(e);
        }

        private void parseAndAppendStatusInfo(@Nonnull TransformerException e) throws TransformerException {
            String errorMessage = StringSupport.trimOrNull((String)e.getMessage());
            if (errorMessage == null) {
                throw e;
            }
            if (errorMessage.startsWith(ERROR_PREFIX)) {
                String statusMessage = StringSupport.trim((String)errorMessage.substring(ERROR_PREFIX.length()));
                this.item.getItemMetadata().put((Object)new ErrorStatus(AbstractXSLProcessingStage.this.ensureId(), statusMessage));
            } else if (errorMessage.startsWith(WARN_PREFIX)) {
                String statusMessage = StringSupport.trim((String)errorMessage.substring(WARN_PREFIX.length()));
                this.item.getItemMetadata().put((Object)new WarningStatus(AbstractXSLProcessingStage.this.ensureId(), statusMessage));
            } else if (errorMessage.startsWith(INFO_PREFIX)) {
                String statusMessage = StringSupport.trim((String)errorMessage.substring(INFO_PREFIX.length()));
                this.item.getItemMetadata().put((Object)new InfoStatus(AbstractXSLProcessingStage.this.ensureId(), statusMessage));
            } else {
                throw e;
            }
        }
    }
}

