/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.metadata.dom.DOMTraversalContext;
import net.shibboleth.metadata.dom.SimpleDOMTraversalContext;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.w3c.dom.Element;

@ThreadSafe
public abstract class AbstractElementVisitingStage
extends AbstractDOMTraversalStage<DOMTraversalContext> {
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @GuardedBy(value="this")
    private Set<QName> elementNames = CollectionSupport.emptySet();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public final synchronized Collection<QName> getElementNames() {
        return this.elementNames;
    }

    public synchronized void setElementNames(@Nonnull @NonnullElements @Unmodifiable Collection<QName> names) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(names, (String)"elementNames may not be null");
        this.elementNames = CollectionSupport.copyToSet(names);
    }

    public synchronized void setElementName(@Nonnull QName name) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)name, (String)"elementName may not be null");
        this.elementNames = CollectionSupport.setOf((Object)name);
    }

    @Override
    protected boolean applicable(@Nonnull Element e, @Nonnull DOMTraversalContext context) {
        QName q = new QName(e.getNamespaceURI(), e.getLocalName());
        return this.getElementNames().contains(q);
    }

    @Override
    @Nonnull
    protected DOMTraversalContext buildContext(@Nonnull Item<Element> item) {
        return new SimpleDOMTraversalContext(item);
    }
}

