/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.thymeleaf.spring.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.factory.AbstractFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;
import org.thymeleaf.spring6.templateresolver.SpringResourceTemplateResolver;

public class TemplateResolverSetFactoryBean
extends AbstractFactoryBean<Set<SpringResourceTemplateResolver>>
implements ApplicationContextAware {
    @Nullable
    private ApplicationContext applicationContext;
    @Nonnull
    private final SpringResourceTemplateResolver resolverTemplate;
    @Nonnull
    private final String[] pathArray;

    TemplateResolverSetFactoryBean(@Nonnull SpringResourceTemplateResolver template) {
        this.resolverTemplate = (SpringResourceTemplateResolver)Constraint.isNotNull((Object)template, (String)"SpringResourceTemplateResolver to use as basis for new objects cannot be null");
        this.pathArray = StringUtils.commaDelimitedListToStringArray((String)StringSupport.trimOrNull((String)template.getPrefix()));
        if (this.pathArray.length == 0) {
            throw new ConstraintViolationException("SpringResourceTemplateResolver prefix cannot be null or empty");
        }
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    @Nullable
    public Class<Set> getObjectType() {
        return Set.class;
    }

    @Nullable
    protected Set<SpringResourceTemplateResolver> createInstance() throws Exception {
        LinkedHashSet<SpringResourceTemplateResolver> results = new LinkedHashSet<SpringResourceTemplateResolver>();
        int i = 1;
        for (String path : this.pathArray) {
            if (path == null || path.isBlank()) continue;
            SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
            resolver.setApplicationContext(this.applicationContext);
            resolver.setOrder(Integer.valueOf(i));
            resolver.setName(this.resolverTemplate.getName() + Integer.toString(i++));
            resolver.setCheckExistence(this.resolverTemplate.getCheckExistence());
            resolver.setCacheable(this.resolverTemplate.isCacheable());
            resolver.setTemplateMode(this.resolverTemplate.getTemplateMode());
            resolver.setPrefix(path);
            resolver.setSuffix(this.resolverTemplate.getSuffix());
            results.add(resolver);
        }
        return results;
    }
}

