/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.thymeleaf.spring.impl;

import java.util.Collections;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.springframework.web.servlet.View;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ChainingThymeleafViewResolver
extends ThymeleafViewResolver {
    @Nonnull
    private final Predicate<String> activationCondition;

    public ChainingThymeleafViewResolver(@Nonnull @ParameterName(name="condition") Predicate<String> condition) {
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        if (this.activationCondition.test(viewName)) {
            return this.checkResource(viewName) ? super.loadView(viewName, locale) : null;
        }
        return null;
    }

    private boolean checkResource(String viewName) {
        IEngineConfiguration config = this.getTemplateEngine().getConfiguration();
        for (ITemplateResolver resolver : config.getTemplateResolvers()) {
            if (resolver.resolveTemplate(config, null, viewName, Collections.emptyMap()) == null) continue;
            return true;
        }
        return false;
    }
}

