/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.scripting.rhino;

import javax.annotation.Nonnull;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.shibboleth.idp.plugin.scripting.AbstractScriptEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoEngine
extends AbstractScriptEngine
implements ScriptEngine,
Compilable {
    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        Context ctx = Context.enter();
        try {
            ImporterTopLevel scope = new ImporterTopLevel(ctx);
            for (String name : bindings.keySet()) {
                Object jsObj = Context.javaToJS((Object)bindings.get(name), (Scriptable)scope);
                ScriptableObject.putProperty((Scriptable)scope, (String)name, (Object)jsObj);
            }
            Object o = ctx.evaluateString((Scriptable)scope, script, "rhino source", 1, null);
            Object object = Context.jsToJava((Object)o, Object.class);
            return object;
        }
        catch (RuntimeException e) {
            throw new ScriptException(e);
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        assert (script != null);
        return new CompiledScriptImpl(script);
    }

    private class CompiledScriptImpl
    extends CompiledScript {
        @Nonnull
        private final Script script;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompiledScriptImpl(String source) {
            Context ctx = Context.enter();
            try {
                Script sc = ctx.compileString(source, "Script", 1, null);
                assert (sc != null);
                this.script = sc;
            }
            finally {
                Context.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object eval(ScriptContext context) throws ScriptException {
            Bindings bindings = context.getBindings(100);
            Context ctx = Context.enter();
            try {
                ImporterTopLevel scope = new ImporterTopLevel(ctx);
                for (String name : bindings.keySet()) {
                    Object jsObj = Context.javaToJS((Object)bindings.get(name), (Scriptable)scope);
                    ScriptableObject.putProperty((Scriptable)scope, (String)name, (Object)jsObj);
                }
                Object o = this.script.exec(ctx, (Scriptable)scope);
                Object object = Context.jsToJava((Object)o, Object.class);
                return object;
            }
            finally {
                Context.exit();
            }
        }

        @Override
        public ScriptEngine getEngine() {
            return RhinoEngine.this;
        }
    }
}

