/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.support;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ClientInformationExtensionSupport {
    @Nonnull
    @NotEmpty
    public static final String KEY_VALIDATED_TRUST_ANCHOR = "oidfed_validated_trust_anchor";
    @Nonnull
    @NotEmpty
    public static final String KEY_VALIDATED_TRUST_CHAIN = "oidfed_validated_trust_chain";
    @Nonnull
    @NotEmpty
    public static final String KEY_VALIDATED_TRUST_MARK_IDS = "oidfed_validated_trust_mark_ids";
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(ClientInformationExtensionSupport.class);

    @Nullable
    public static String parseValidatedTrustAnchor(@Nonnull OIDCClientInformation clientInformation) {
        return Optional.ofNullable(clientInformation.getOIDCMetadata().getCustomField(KEY_VALIDATED_TRUST_ANCHOR)).filter(String.class::isInstance).map(obj -> obj.toString()).orElse(null);
    }

    @Nullable
    public static List<String> parseValidatedTrustChain(@Nonnull OIDCClientInformation clientInformation) {
        return Optional.ofNullable(clientInformation.getOIDCMetadata().getCustomField(KEY_VALIDATED_TRUST_CHAIN)).filter(List.class::isInstance).map(obj -> (List)obj).map(list -> list.stream().map(String.class::cast).toList()).orElse(null);
    }

    @Nullable
    public static Map<String, List<String>> parseValidatedTrustMarkIds(@Nonnull OIDCClientInformation clientInformation) {
        return Optional.ofNullable(clientInformation.getOIDCMetadata().getCustomField(KEY_VALIDATED_TRUST_MARK_IDS)).filter(Map.class::isInstance).map(obj -> (Map)obj).map(map -> map.entrySet().stream().filter(entry -> entry.getKey() instanceof String).filter(entry -> entry.getValue() instanceof List).collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> ((List)entry.getValue()).stream().filter(Objects::nonNull).map(Objects::toString).toList()))).orElse(null);
    }
}

