/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.support;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ClaimsSetExtensionSupport {
    @Nonnull
    @NotEmpty
    public static final String KEY_AUTO_REGISTERED_TRUST_CHAIN = "oidfed_artc";
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(ClaimsSetExtensionSupport.class);

    @Nullable
    public static List<String> parseAutoRegisteredTrustChain(@Nonnull TokenClaimsSet claimsSet) {
        return ClaimsSetExtensionSupport.parseAutoRegisteredTrustChain(claimsSet.getClaimsSet());
    }

    @Nullable
    public static List<String> parseAutoRegisteredTrustChain(@Nonnull JWTClaimsSet claimsSet) {
        try {
            return claimsSet.getStringListClaim(KEY_AUTO_REGISTERED_TRUST_CHAIN);
        }
        catch (ParseException e) {
            log.warn("Could not parse auto registered trust chain from the claims set", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static List<String> parseAutoRegisteredTrustChain(@Nonnull Map<String, Object> claimsSet) {
        return Optional.ofNullable(claimsSet.get(KEY_AUTO_REGISTERED_TRUST_CHAIN)).filter(List.class::isInstance).map(List.class::cast).map(list -> list.stream().filter(Objects::nonNull).map(Objects::toString).toList()).orElse(null);
    }
}

