/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.navigate;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.oidc.op.oidfed.support.ClientInformationExtensionSupport;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class TrustAnchorIdLookupFunction
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy;

    public TrustAnchorIdLookupFunction() {
        this.oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();
    }

    public TrustAnchorIdLookupFunction(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataStrategy) {
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(oidcMetadataStrategy, (String)"OIDC metadata context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext profileRequestContext) {
        return Optional.ofNullable(this.oidcMetadataContextLookupStrategy.apply(profileRequestContext)).map(oidcContext -> oidcContext.getClientInformation()).map(clientInfo -> ClientInformationExtensionSupport.parseValidatedTrustAnchor(clientInfo)).orElse(null);
    }
}

