/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context;

import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.logic.TrustAnchorIdPredicate;
import net.shibboleth.profile.relyingparty.BasicRelyingPartyConfiguration;
import net.shibboleth.shared.logic.Constraint;

public class RelyingPartyConfigurationSupport {
    @Nonnull
    public static BasicRelyingPartyConfiguration byTrustAnchor(@Nonnull Collection<String> trustAnchorIds) {
        Constraint.isNotNull(trustAnchorIds, (String)"Trust Anchor ID list cannot be null");
        BasicRelyingPartyConfiguration config = new BasicRelyingPartyConfiguration();
        config.setActivationCondition((Predicate)((Object)new TrustAnchorIdPredicate(trustAnchorIds)));
        StringBuffer name = new StringBuffer("TrustAnchorIDs[");
        for (String taId : trustAnchorIds) {
            name.append(taId).append(',');
        }
        name.append(']');
        String id = name.toString();
        assert (id != null);
        config.setId(id);
        return config;
    }
}

