/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.TrustedRemoteEntity;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

public class TrustedRemoteResolverEntity
extends TrustedRemoteEntity {
    @Nonnull
    @NotEmpty
    private final Collection<String> trustAnchors;

    public TrustedRemoteResolverEntity(@Nonnull @ParameterName(name="entity") @NotEmpty String entity, @Nonnull @ParameterName(name="anchors") @NotEmpty Collection<String> anchors) {
        super(entity);
        this.trustAnchors = Constraint.isNotEmpty(anchors, (String)"Trust Anchors cannot be empty");
    }

    @Nonnull
    @NotEmpty
    public Collection<String> getTrustAnchors() {
        return this.trustAnchors;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this.getEntityId()).add("trustAnchors", this.getTrustAnchors()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrustedRemoteResolverEntity other = (TrustedRemoteResolverEntity)obj;
        return this.getEntityId().equals(other.getEntityId()) && this.trustAnchors.containsAll(other.trustAnchors) && other.trustAnchors.containsAll(this.trustAnchors);
    }
}

