/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ExplicitClientRegistrationRequest;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

@ThreadSafe
public class ExplicitClientRegistrationRequestClientIDLookupFunction
implements ContextDataLookupFunction<MessageContext, ClientID> {
    @Nullable
    public ClientID apply(@Nullable MessageContext input) {
        return Optional.ofNullable(input).map(messageContext -> messageContext.getMessage()).filter(ExplicitClientRegistrationRequest.class::isInstance).map(ExplicitClientRegistrationRequest.class::cast).map(request -> this.getClientID((ExplicitClientRegistrationRequest)request)).orElse(null);
    }

    @Nullable
    protected ClientID getClientID(@Nullable ExplicitClientRegistrationRequest request) {
        if (request == null) {
            return null;
        }
        EntityStatement entityConfiguration = request.getEntityConfiguration();
        if (entityConfiguration != null) {
            return new ClientID((Identifier)entityConfiguration.getEntityID());
        }
        List<EntityStatement> trustChain = request.getTrustChain();
        return trustChain != null && !trustChain.isEmpty() ? new ClientID((Identifier)trustChain.get(0).getEntityID()) : null;
    }
}

