/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.AbstractTrustChainContextLookupFunction;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultTrustChainSelectionStrategy
extends AbstractTrustChainContextLookupFunction<Pair<List<EntityStatement>, Map<String, Map<String, Object>>>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustChainSelectionStrategy.class);

    @Override
    @Nullable
    public Pair<List<EntityStatement>, Map<String, Map<String, Object>>> doApply(@Nonnull RelyingPartyTrustChainContext trustChainContext) {
        List policyCompliantChains = trustChainContext.getPolicyCompliantTrustChains();
        if (policyCompliantChains == null || policyCompliantChains.isEmpty()) {
            this.log.debug("No policy compliant chains located");
            return null;
        }
        this.log.trace("Policy-compatible trust chains: {}", (Object)policyCompliantChains.size());
        if (policyCompliantChains.size() > 1) {
            int shortestIndex = -1;
            for (int i = 0; i < policyCompliantChains.size(); ++i) {
                List candidate = (List)((Pair)policyCompliantChains.get(i)).getFirst();
                if (this.isTrustChainRejected(trustChainContext, candidate)) continue;
                if (shortestIndex == -1) {
                    shortestIndex = i;
                    continue;
                }
                List shortest = (List)((Pair)policyCompliantChains.get(shortestIndex)).getFirst();
                if (candidate == null || shortest == null || candidate.size() >= shortest.size()) continue;
                shortestIndex = i;
            }
            this.log.trace("Shortest non-rejected index {}", (Object)shortestIndex);
            return shortestIndex == -1 ? null : (Pair)policyCompliantChains.get(shortestIndex);
        }
        List candidate = (List)((Pair)policyCompliantChains.get(0)).getFirst();
        return this.isTrustChainRejected(trustChainContext, candidate) ? null : (Pair)policyCompliantChains.get(0);
    }

    private boolean isTrustChainRejected(@Nonnull RelyingPartyTrustChainContext trustChainContext, @Nullable List<EntityStatement> trustChain) {
        if (trustChain == null) {
            return true;
        }
        List rejectedTrustChains = trustChainContext.getRejectedTrustChains();
        return rejectedTrustChains != null && rejectedTrustChains.contains(trustChain);
    }
}

