/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.LocalKeyContainer;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultTrustAnchorHintsLookupStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, List<String>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustAnchorHintsLookupStrategy.class);
    @NonnullAfterInit
    private MetadataCache<Map<String, LocalKeyContainer>> trustAnchorsCache;

    public void setTrustAnchorsCache(@Nonnull MetadataCache<Map<String, LocalKeyContainer>> cache) {
        this.checkSetterPreconditions();
        this.trustAnchorsCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Trust Anchors cache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.trustAnchorsCache == null) {
            throw new ComponentInitializationException("Trust Anchors cache cannot be null");
        }
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable ProfileRequestContext profileRequestContext) {
        List keyContainers;
        this.checkComponentActive();
        try {
            keyContainers = this.trustAnchorsCache.get(new CriteriaSet());
        }
        catch (MetadataCacheException e) {
            this.log.warn("Could not resolve any trust anchors", (Throwable)e);
            return null;
        }
        if (keyContainers == null || keyContainers.isEmpty()) {
            this.log.debug("No keycontainers returned from the trust anchor cache");
            return null;
        }
        return ((Map)keyContainers.get(0)).keySet().stream().filter(Objects::nonNull).toList();
    }
}

