/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.support.ClaimsSetExtensionSupport;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultPreSelectedTrustChainIDsLookupStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, List<String>> {
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> profileIdLookupStrategy;
    @Nonnull
    private Map<String, Function<ProfileRequestContext, List<String>>> profileSpecificStrategies = CollectionSupport.emptyMap();

    public void setProfileIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.profileIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileIdLookupStrategy cannot be null");
    }

    public void setProfileSpecificStrategies(@Nonnull Map<String, Function<ProfileRequestContext, List<String>>> strategies) {
        this.checkSetterPreconditions();
        this.profileSpecificStrategies = (Map)Constraint.isNotNull(strategies, (String)"ProfileSpecificStrategies cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.profileIdLookupStrategy == null) {
            throw new ComponentInitializationException("ProfileIdLookupStrategy cannot be null");
        }
        if (this.profileSpecificStrategies == null) {
            throw new ComponentInitializationException("ProfileSpecificStrategies cannot be null");
        }
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable ProfileRequestContext input) {
        this.checkComponentActive();
        return Optional.ofNullable(this.profileIdLookupStrategy.apply(input)).map(profileId -> this.profileSpecificStrategies.get(profileId)).map(function -> (List)function.apply(input)).orElse(this.defaultValue(input));
    }

    private List<String> defaultValue(@Nullable ProfileRequestContext input) {
        return Optional.ofNullable(input).filter(prc -> prc.getOutboundMessageContext() != null).map(prc -> prc.ensureOutboundMessageContext()).filter(msgCtx -> msgCtx.containsSubcontext(OIDCAuthenticationResponseContext.class)).map(msgCtx -> (OIDCAuthenticationResponseContext)msgCtx.ensureSubcontext(OIDCAuthenticationResponseContext.class)).map(oidcResponseCtx -> oidcResponseCtx.getAuthorizationGrantClaimsSet()).filter(Objects::nonNull).map(ClaimsSetExtensionSupport::parseAutoRegisteredTrustChain).orElse(null);
    }
}

