/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class DefaultMetadataValidationCondition
implements BiPredicate<String, Map<String, Object>> {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(DefaultMetadataValidationCondition.class);

    @Override
    public boolean test(@Nullable String key, @Nullable Map<String, Object> metadata) {
        if (StringSupport.trimOrNull((String)key) == null || metadata == null) {
            log.error("Invalid input to the validation condition key={}, metadata={}", (Object)key, metadata);
            return false;
        }
        try {
            switch (key) {
                case "federation_entity": {
                    log.debug("Ignoring validation of {}", (Object)key);
                    return true;
                }
                case "openid_provider": {
                    OIDCProviderMetadata.parse((JSONObject)new JSONObject(metadata));
                    return true;
                }
                case "openid_relying_party": {
                    OIDCClientMetadata.parse((JSONObject)new JSONObject(metadata));
                    return true;
                }
                case "oauth_authorization_server": {
                    AuthorizationServerMetadata.parse((JSONObject)new JSONObject(metadata));
                    return true;
                }
                case "oauth_client": {
                    ClientMetadata.parse((JSONObject)new JSONObject(metadata));
                    return true;
                }
                case "oauth_resource": {
                    log.debug("Ignoring validation of {}", (Object)key);
                    return true;
                }
            }
            log.debug("Ignoring validation of {}", (Object)key);
            return true;
        }
        catch (ParseException e) {
            log.warn("Could not parse entity_type {}", (Object)key, (Object)e);
            return false;
        }
    }
}

