/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultLocalMetadataPolicyMergingStrategy
extends AbstractIdentifiableInitializableComponent
implements BiFunction<OIDCClientInformation, Map<String, MetadataPolicy>, OIDCClientInformation> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultLocalMetadataPolicyMergingStrategy.class);
    @NonnullAfterInit
    private BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> metadataPolicyEnforcer;

    public void setMetadataPolicyEnforcer(@Nonnull BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> enforcer) {
        this.checkSetterPreconditions();
        this.metadataPolicyEnforcer = (BiFunction)Constraint.isNotNull(enforcer, (String)"Metadata policy enforcer cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataPolicyEnforcer == null) {
            throw new ComponentInitializationException("MetadataPolicyEnforcer cannot be null");
        }
    }

    @Override
    @Nullable
    public OIDCClientInformation apply(@Nullable OIDCClientInformation inputMetadata, @Nullable Map<String, MetadataPolicy> localPolicy) {
        this.checkComponentActive();
        if (inputMetadata == null) {
            return null;
        }
        if (localPolicy == null || localPolicy.isEmpty()) {
            return inputMetadata;
        }
        JSONObject result = inputMetadata.toJSONObject();
        boolean compliant = true;
        for (String claim : localPolicy.keySet()) {
            Boolean enforcerResult;
            MetadataPolicy policy = localPolicy.get(claim);
            Object value = inputMetadata.getOIDCMetadata().toJSONObject().get((Object)claim);
            this.log.debug("Claim {} set in policy included in the input: {}", (Object)claim, (Object)(value == null ? 1 : 0));
            Pair<Object, Boolean> mergeResult = this.metadataPolicyEnforcer.apply(value, policy);
            Boolean bl = enforcerResult = mergeResult != null ? (Boolean)mergeResult.getSecond() : null;
            if (enforcerResult == null || !enforcerResult.booleanValue()) {
                this.log.warn("Metadata claim {} is not compliant with the policy", (Object)claim);
                compliant = false;
                continue;
            }
            this.log.trace("Validation result is OK for claim {}", (Object)claim);
            Object enforcedValue = mergeResult != null ? mergeResult.getFirst() : null;
            result.put((Object)claim, enforcedValue);
        }
        if (!compliant) {
            this.log.warn("The requested metadata is not compliant with the policy");
        } else {
            this.log.debug("The requested metadata is compliant with the policy");
            try {
                this.log.trace("Attempting to parse the metadata {}", (Object)result.toJSONString());
                return OIDCClientInformation.parse((JSONObject)result);
            }
            catch (ParseException e) {
                this.log.error("Could not parse the metadata object", (Throwable)e);
            }
        }
        return null;
    }
}

