/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultEntityConfigurationTrustMarksLookupStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, List<Map<String, String>>> {
    @Nonnull
    private List<Function<ProfileRequestContext, Map<String, String>>> trustMarkLookupStrategies = CollectionSupport.emptyList();

    public void setTrustMarkLookupStrategies(@Nonnull List<Function<ProfileRequestContext, Map<String, String>>> strategies) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(strategies, (String)"Trust mark lookup strategies cannot be null");
        this.trustMarkLookupStrategies = strategies;
    }

    @Override
    @Nonnull
    public List<Map<String, String>> apply(@Nullable ProfileRequestContext profileRequestContext) {
        this.checkComponentActive();
        ArrayList trustMarks = new ArrayList();
        for (Function<ProfileRequestContext, Map<String, String>> strategy : this.trustMarkLookupStrategies) {
            if (strategy == null) continue;
            Optional.ofNullable(strategy.apply(profileRequestContext)).filter(trustMark -> trustMark != null && !trustMark.isEmpty()).ifPresent(trustMark -> trustMarks.add(trustMark));
        }
        return CollectionSupport.copyToList(trustMarks);
    }
}

