/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.RelyingPartyTrustChainContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public abstract class AbstractTrustChainContextLookupFunction<T>
implements Function<ProfileRequestContext, T> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractTrustChainContextLookupFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;

    public AbstractTrustChainContextLookupFunction() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    @Override
    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        RelyingPartyTrustChainContext trustChainContext = this.trustChainContextLookupStrategy.apply(input);
        if (trustChainContext == null) {
            this.log.debug("Could not resolve trust chain context, returning null");
            return null;
        }
        return this.doApply(trustChainContext);
    }

    @Nullable
    protected abstract T doApply(@Nonnull RelyingPartyTrustChainContext var1);
}

