/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.logic;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultAutomaticRegistrationActivationCondition
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> profileIdLookupStrategy;
    @NonnullAfterInit
    private Map<String, Predicate<ProfileRequestContext>> profileConditions;

    public void setProfileIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.profileIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileIdLookupStrategy cannot be null");
    }

    public void setProfileConditions(@Nonnull Map<String, Predicate<ProfileRequestContext>> conditions) {
        this.checkSetterPreconditions();
        this.profileConditions = (Map)Constraint.isNotNull(conditions, (String)"ProfileConditions cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.profileIdLookupStrategy == null) {
            throw new ComponentInitializationException("ProfileIdLookupStrategy cannot be null");
        }
        if (this.profileConditions == null) {
            throw new ComponentInitializationException("ProfileConditions cannot be null");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext profileRequestContext) {
        return Optional.ofNullable(profileRequestContext).map(prc -> this.profileIdLookupStrategy.apply((ProfileRequestContext)prc)).map(profileId -> this.profileConditions.get(profileId)).map(condition -> condition.test(profileRequestContext)).orElse(false);
    }
}

