/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.AbstractTrustChainResolutionAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateProvidedTrustChain
extends AbstractTrustChainResolutionAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateProvidedTrustChain.class);
    @NonnullAfterInit
    private BiPredicate<ProfileRequestContext, List<EntityStatement>> providedTrustChainValidationStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<EntityStatement>> providedTrustChainLookupStrategy;
    @NonnullBeforeExec
    private List<EntityStatement> trustChain;

    public void setProvidedTrustChainLookupStrategy(@Nonnull Function<ProfileRequestContext, List<EntityStatement>> strategy) {
        this.providedTrustChainLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProvidedTrustChainLookupStrategy cannot be null");
    }

    public void setProvidedTrustChainValidationStrategy(@Nonnull BiPredicate<ProfileRequestContext, List<EntityStatement>> strategy) {
        this.checkSetterPreconditions();
        this.providedTrustChainValidationStrategy = (BiPredicate)Constraint.isNotNull(strategy, (String)"ProvidedTrustChainValidationStrategy cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.providedTrustChainLookupStrategy == null) {
            throw new ComponentInitializationException("ProvidedTrustChainLookupStrategy cannot be null");
        }
        if (this.providedTrustChainValidationStrategy == null) {
            throw new ComponentInitializationException("ProvidedTrustChainValidationStrategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.trustChain = this.providedTrustChainLookupStrategy.apply(profileRequestContext);
        if (this.trustChain == null) {
            this.log.error("{} Unable to fetch trust chain", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.providedTrustChainValidationStrategy.test(profileRequestContext, this.trustChain)) {
            this.log.error("{} The trust chain validation failed", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        RelyingPartyTrustChainContext trustChainContext = this.getTrustChainContextCreationStrategy().apply(profileRequestContext);
        assert (this.trustChain != null);
        trustChainContext.setResolvedTrustChains(CollectionSupport.listOf(this.trustChain));
        ArrayList<Pair<List<EntityStatement>, Map<String, Map<String, Object>>>> policyCompliantChains = new ArrayList<Pair<List<EntityStatement>, Map<String, Map<String, Object>>>>();
        String errorEventId = this.populatePolicyComplaintChains(this.trustChain, policyCompliantChains);
        if (errorEventId != null) {
            this.log.error("{} The request metadata is not compliant with the merged policy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)errorEventId);
            return;
        }
        this.log.debug("{} Setting the policy compliant trust chains into the context: {}", (Object)this.getLogPrefix(), policyCompliantChains);
        trustChainContext.setPolicyCompliantTrustChains(policyCompliantChains);
    }
}

