/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateProvidedEntityConfiguration
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateProvidedEntityConfiguration.class);
    @NonnullAfterInit
    private BiPredicate<ProfileRequestContext, EntityStatement> providedEntityConfigurationValidationStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, EntityStatement> providedEntityConfigurationLookupStrategy;
    @NonnullBeforeExec
    private EntityStatement entityConfiguration;

    public void setProvidedEntityConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, EntityStatement> strategy) {
        this.providedEntityConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProvidedEntityConfigurationLookupStrategy cannot be null");
    }

    public void setProvidedEntityConfigurationValidationStrategy(@Nonnull BiPredicate<ProfileRequestContext, EntityStatement> strategy) {
        this.checkSetterPreconditions();
        this.providedEntityConfigurationValidationStrategy = (BiPredicate)Constraint.isNotNull(strategy, (String)"ProvidedEntityConfigurationValidationStrategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.providedEntityConfigurationLookupStrategy == null) {
            throw new ComponentInitializationException("ProvidedEntityConfigurationLookupStrategy cannot be null");
        }
        if (this.providedEntityConfigurationValidationStrategy == null) {
            throw new ComponentInitializationException("ProvidedEntityConfigurationValidationStrategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.entityConfiguration = this.providedEntityConfigurationLookupStrategy.apply(profileRequestContext);
        if (this.entityConfiguration == null) {
            this.log.error("{} Unable to fetch entity configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.providedEntityConfigurationValidationStrategy.test(profileRequestContext, this.entityConfiguration)) {
            this.log.error("{} The entity configuration validation failed", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        this.log.debug("{} The provided entity configuration successfully validated", (Object)this.getLogPrefix());
    }
}

