/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.AbstractTrustChainResolutionAction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultPreSelectedTrustChainIDsLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultTrustChainIDsLookupStrategy;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ResolveTrustChains
extends AbstractTrustChainResolutionAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ResolveTrustChains.class);
    @NonnullAfterInit
    private MetadataCache<List<List<EntityStatement>>> trustChainCache;
    @NonnullAfterInit
    private Function<MessageContext, ClientID> clientIDLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> preSelectedTrustChainIdsLookupStrategy = new DefaultPreSelectedTrustChainIDsLookupStrategy();
    @Nonnull
    private Function<List<EntityStatement>, List<String>> trustChainIDsLookupStrategy = new DefaultTrustChainIDsLookupStrategy();
    @Nonnull
    private Function<ProfileRequestContext, EntityStatement> entityConfigurationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> requireEntityConfigurationCondition = PredicateSupport.alwaysFalse();
    @NonnullBeforeExec
    private String clientId;

    public void setTrustChainCache(@Nonnull MetadataCache<List<List<EntityStatement>>> cache) {
        this.checkSetterPreconditions();
        this.trustChainCache = (MetadataCache)Constraint.isNotNull(cache, (String)"TrustChainCache cannot be null");
    }

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.checkSetterPreconditions();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy cannot be null");
    }

    public void setPreSelectedTrustChainIdsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.preSelectedTrustChainIdsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"PreSelectedTrustChainIdsLookupStrategy cannot be null");
    }

    public void setTrustChainIDsLookupStrategy(@Nonnull Function<List<EntityStatement>, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.trustChainIDsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainIDsLookupStrategy cannot be null");
    }

    public void setEntityConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, EntityStatement> strategy) {
        this.checkSetterPreconditions();
        this.entityConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EntityConfigurationLookupStrategy cannot be null");
    }

    public void setRequireEntityConfigurationCondition(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.requireEntityConfigurationCondition = (Predicate)Constraint.isNotNull(predicate, (String)"RequireEntityConfigurationCondition cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.trustChainCache == null) {
            throw new ComponentInitializationException("TrustChainCache cannot be null");
        }
        if (this.clientIDLookupStrategy == null) {
            throw new ComponentInitializationException("ClientIDLookupStrategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        ClientID id = this.clientIDLookupStrategy.apply(profileRequestContext.getInboundMessageContext());
        if (id == null) {
            this.log.error("{} Unable to obtain client ID", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.clientId = id.getValue();
        try {
            new URL(this.clientId).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.log.debug("{} The client ID {} is not a valid URL, nothing to do", (Object)this.getLogPrefix(), (Object)this.clientId);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        List cacheResult;
        this.log.debug("{} Resolving trust chain for {}", (Object)this.getLogPrefix(), (Object)this.clientId);
        assert (this.clientId != null);
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(this.clientId)});
        EntityStatement entityConfiguration = this.entityConfigurationLookupStrategy.apply(profileRequestContext);
        if (entityConfiguration != null) {
            this.log.debug("{} Entity configuration resolved and included to the criteria set", (Object)this.getLogPrefix());
            criteriaSet.add((Object)new SubjectEntityStatementCriterion(entityConfiguration));
        } else if (this.requireEntityConfigurationCondition.test(profileRequestContext)) {
            this.log.error("{} Mandatory entity configuration could not be resolved", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        try {
            cacheResult = this.trustChainCache.get(criteriaSet);
        }
        catch (MetadataCacheException e) {
            this.log.warn("{} Could fetch trust chains for {}", (Object)this.getLogPrefix(), (Object)this.clientId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoTrustChainsResolved");
            return;
        }
        if (cacheResult.isEmpty()) {
            this.log.debug("{} No trust chains resolved for {}", (Object)this.getLogPrefix(), (Object)this.clientId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoTrustChainsResolved");
            return;
        }
        List<String> preSelectedChain = Optional.ofNullable(this.preSelectedTrustChainIdsLookupStrategy.apply(profileRequestContext)).orElse(CollectionSupport.emptyList());
        RelyingPartyTrustChainContext trustChainContext = this.getTrustChainContextCreationStrategy().apply(profileRequestContext);
        trustChainContext.setResolvedTrustChains((List)cacheResult.get(0));
        ArrayList<Pair<List<EntityStatement>, Map<String, Map<String, Object>>>> policyCompliantChains = new ArrayList<Pair<List<EntityStatement>, Map<String, Map<String, Object>>>>();
        String errorEventId = null;
        for (List chain : (List)cacheResult.get(0)) {
            assert (chain != null);
            if (!preSelectedChain.isEmpty() && !preSelectedChain.equals(this.trustChainIDsLookupStrategy.apply(chain))) {
                this.log.debug("{} Ignored resolved trust chain that doesn't match with preselected chain", (Object)this.getLogPrefix());
                continue;
            }
            errorEventId = this.populatePolicyComplaintChains(chain, policyCompliantChains);
        }
        if (policyCompliantChains.isEmpty()) {
            if (errorEventId == null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoTrustChainsResolved");
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, errorEventId);
            }
            return;
        }
        this.log.debug("{} Setting the policy compliant trust chains into the context: {}", (Object)this.getLogPrefix(), policyCompliantChains);
        trustChainContext.setPolicyCompliantTrustChains(policyCompliantChains);
    }
}

