/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.ProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.EntityStatementContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class InitializeEntityStatementContext
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(InitializeEntityStatementContext.class);
    @NonnullAfterInit
    private ProviderMetadataResolver metadataResolver;
    @NonnullAfterInit
    private Function<CriteriaSet, Map<String, Map<String, Object>>> metadataSkeletonLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, EntityStatementContext> entityStatementContextCreationStrategy;
    @NonnullBeforeExec
    private EntityStatementContext entityStatementCtx;
    @NonnullBeforeExec
    private Map<String, Map<String, Object>> metadataSkeleton;

    public InitializeEntityStatementContext() {
        Function esccs = new ChildContextLookup(EntityStatementContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (esccs != null);
        this.entityStatementContextCreationStrategy = esccs;
    }

    public void setMetadataResolver(@Nonnull ProviderMetadataResolver resolver) {
        this.metadataResolver = (ProviderMetadataResolver)Constraint.isNotNull((Object)resolver, (String)"The metadata resolver cannot be null!");
    }

    public void setMetadataSkeletonLookupStrategy(@Nonnull Function<CriteriaSet, Map<String, Map<String, Object>>> strategy) {
        this.checkSetterPreconditions();
        this.metadataSkeletonLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MetadataSkeletonLookupStrategy cannot be null");
    }

    public void setEntityStatementContextCreationStrategy(@Nonnull Function<ProfileRequestContext, EntityStatementContext> strategy) {
        this.checkSetterPreconditions();
        this.entityStatementContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"EntityStatementContext creation strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataResolver == null) {
            throw new ComponentInitializationException("The metadata resolver cannot be null!");
        }
        if (this.metadataSkeletonLookupStrategy == null) {
            throw new ComponentInitializationException("MetadataSkeletonLookupStrategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.entityStatementCtx = this.entityStatementContextCreationStrategy.apply(profileRequestContext);
        if (this.entityStatementCtx == null) {
            this.log.error("{} Unable to create EntityStatementContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.metadataSkeleton = Optional.ofNullable(this.metadataSkeletonLookupStrategy.apply(new CriteriaSet())).orElseGet((Supplier<Map<String, Map<String, Object>>>)NonnullSupplier.of((Object)CollectionSupport.emptyMap()));
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCProviderMetadata metadata;
        try {
            metadata = (OIDCProviderMetadata)this.metadataResolver.resolveSingle((Object)profileRequestContext);
        }
        catch (ResolverException e) {
            this.log.error("{} Could not resolve provider metadata", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return;
        }
        if (metadata == null) {
            this.log.error("{} Could not resolve provider metadata", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return;
        }
        this.entityStatementCtx.setMetadata(this.mergeMetadata(this.metadataSkeleton, "openid_provider", (Map<String, Object>)metadata.toJSONObject()));
    }

    protected Map<String, Map<String, Object>> mergeMetadata(@Nonnull Map<String, Map<String, Object>> metadata, @Nonnull String key, @Nonnull Map<String, Object> input) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(metadata);
        Map<String, Object> base = metadata.get(key);
        if (base != null) {
            HashMap<String, Object> values = new HashMap<String, Object>(base);
            values.putAll(input);
            result.put(key, values);
        } else {
            result.put(key, input);
        }
        return result;
    }
}

