/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.openid.connect.sdk.federation.config.FederationEntityConfigurationSuccessResponse;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.navigate.CachedSuccessResponseLifetimeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.EntityStatementContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyCachedMessageContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class FormOutboundFederationConfigurationResponse
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FormOutboundFederationConfigurationResponse.class);
    @NonnullAfterInit
    private MetadataCache<NimbusResponseContainer> responseCache;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyCachedMessageContext> cachedMessageContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, EntityStatementContext> entityStatementContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> cachedResponseLifetimeLookupStrategy;
    @Nullable
    private SignedJWT jwt;
    @NonnullBeforeExec
    private RelyingPartyCachedMessageContext cachedMessageContext;

    public FormOutboundFederationConfigurationResponse() {
        Function escls = new ChildContextLookup(EntityStatementContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (escls != null);
        this.entityStatementContextLookupStrategy = escls;
        this.cachedMessageContextLookupStrategy = new ChildContextLookup(RelyingPartyCachedMessageContext.class);
        this.cachedResponseLifetimeLookupStrategy = new CachedSuccessResponseLifetimeLookupFunction();
    }

    public void setEntityStatementContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EntityStatementContext> strategy) {
        this.checkSetterPreconditions();
        this.entityStatementContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null!");
    }

    public void setCachedMessageContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyCachedMessageContext> strategy) {
        this.checkSetterPreconditions();
        this.cachedMessageContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null!");
    }

    public void setResponseCache(@Nonnull MetadataCache<NimbusResponseContainer> cache) {
        this.checkSetterPreconditions();
        this.responseCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Response metadata cache cannot be null");
    }

    public void setCachedResponseLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.cachedResponseLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.responseCache == null) {
            throw new ComponentInitializationException("Response metadata cache cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.cachedMessageContext = this.cachedMessageContextLookupStrategy.apply(profileRequestContext);
        if (this.cachedMessageContext == null) {
            this.log.error("{} Could not resolve cached message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        FederationEntityConfigurationSuccessResponse response;
        SignedJWT signedJwt;
        Response cachedResponse = this.cachedMessageContext.getCachedResponse();
        if (cachedResponse != null) {
            this.log.debug("{} Cached response found, storing in to the outbound message context", (Object)this.getLogPrefix());
            profileRequestContext.ensureOutboundMessageContext().setMessage((Object)cachedResponse);
            return;
        }
        this.log.debug("{} No cached response found, resolving the response JWT from the context", (Object)this.getLogPrefix());
        EntityStatementContext entityStatementContext = this.entityStatementContextLookupStrategy.apply(profileRequestContext);
        if (entityStatementContext == null) {
            this.log.error("{} Could not resolve entity statement context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        JWT jWT = entityStatementContext.getJWT();
        if (!(jWT instanceof SignedJWT)) {
            this.log.error("{} No signed JWT found from the entity statement context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        this.jwt = signedJwt = (SignedJWT)jWT;
        assert (this.jwt != null);
        try {
            response = new FederationEntityConfigurationSuccessResponse(EntityStatement.parse((SignedJWT)this.jwt));
        }
        catch (ParseException e) {
            this.log.error("{} No signed JWT found from the entity statement context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        NimbusResponseCriterion responseCriterion = new NimbusResponseCriterion((Response)response);
        Duration lifetime = this.cachedResponseLifetimeLookupStrategy.apply(profileRequestContext);
        if (lifetime == null) {
            this.log.error("{} Could not resolve lifetime for the cached response record", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        Instant expiration = Instant.now().plus(lifetime);
        assert (expiration != null);
        ResponseContainerExpirationCriterion expirationCriterion = new ResponseContainerExpirationCriterion(expiration);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{responseCriterion, expirationCriterion});
        try {
            List result = this.responseCache.get(criteria);
            if (result.size() != 1) {
                this.log.error("{} Unexpected result (size={}) when storing response record into the metadata cache", (Object)this.getLogPrefix(), (Object)result.size());
            } else {
                this.log.debug("{} Response stored into the cache", (Object)this.getLogPrefix());
            }
        }
        catch (MetadataCacheException e) {
            this.log.error("{} Could not store the response record into tht metadata cache", (Object)this.getLogPrefix(), (Object)e);
        }
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)response);
    }
}

