/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ExplicitClientRegistrationResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.EntityStatementContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class FormExplicitRegistrationResponse
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FormExplicitRegistrationResponse.class);
    @Nonnull
    private Function<ProfileRequestContext, EntityStatementContext> entityStatementContextLookupStrategy;
    @Nullable
    private SignedJWT jwt;

    public FormExplicitRegistrationResponse() {
        Function escls = new ChildContextLookup(EntityStatementContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (escls != null);
        this.entityStatementContextLookupStrategy = escls;
    }

    public void setEntityStatementContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EntityStatementContext> strategy) {
        this.checkSetterPreconditions();
        this.entityStatementContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null!");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SignedJWT signedJwt;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        EntityStatementContext entityStatementContext = this.entityStatementContextLookupStrategy.apply(profileRequestContext);
        if (entityStatementContext == null) {
            this.log.error("{} Could not resolve entity statement context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        JWT jWT = entityStatementContext.getJWT();
        if (!(jWT instanceof SignedJWT)) {
            this.log.error("{} No signed JWT found from the entity statement context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.jwt = signedJwt = (SignedJWT)jWT;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EntityStatement entityStatement;
        try {
            entityStatement = EntityStatement.parse((SignedJWT)this.jwt);
        }
        catch (ParseException e) {
            this.log.error("{} Could not parse entity statement from JWT", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        assert (entityStatement != null);
        ExplicitClientRegistrationResponse response = new ExplicitClientRegistrationResponse(this.jwt);
        this.log.debug("{} Response message set to the outbound message context", (Object)this.getLogPrefix());
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)response);
    }
}

