/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.TrustMarkRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.TrustMarkResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.EntityStatementHelper;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.TrustMarkRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.TrustMarkResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.TrustedRemoteEntity;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultTrustMarkFromMetadataCacheFetchingFunction
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, Map<String, String>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustMarkFromMetadataCacheFetchingFunction.class);
    @NonnullAfterInit
    private MetadataCache<EntityStatement> entityConfigurationCache;
    @NonnullAfterInit
    private MetadataCache<TrustMarkResponseContainer> trustMarkCache;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @NonnullAfterInit
    private TrustedRemoteEntity trustedEntity;
    @NonnullAfterInit
    private String trustMarkType;
    @NonnullAfterInit
    private String subject;
    @Nonnull
    private Duration cachedLifetime = Duration.ofHours(1L);

    public void setEntityConfigurationCache(@Nonnull MetadataCache<EntityStatement> cache) {
        this.checkSetterPreconditions();
        this.entityConfigurationCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Entity Configuration cache cannot be null");
    }

    public void setTrustMarkCache(@Nonnull MetadataCache<TrustMarkResponseContainer> cache) {
        this.checkSetterPreconditions();
        this.trustMarkCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Trust Mark cache cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setTrustedEntity(@Nonnull TrustedRemoteEntity entity) {
        this.checkSetterPreconditions();
        this.trustedEntity = (TrustedRemoteEntity)Constraint.isNotNull((Object)entity, (String)"Trusted entity cannot be null");
    }

    public void setTrustMarkType(@Nonnull @NotEmpty String type) {
        this.checkSetterPreconditions();
        this.trustMarkType = Constraint.isNotEmpty((String)type, (String)"Trust mark type cannot be empty");
    }

    public void setSubject(@Nonnull @NotEmpty String sub) {
        this.checkSetterPreconditions();
        this.subject = Constraint.isNotEmpty((String)sub, (String)"Subject cannot be empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.entityConfigurationCache == null) {
            throw new ComponentInitializationException("Entity configuration cache cannot be null");
        }
        if (this.trustMarkCache == null) {
            throw new ComponentInitializationException("Trust Mark cache cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
        if (this.trustedEntity == null) {
            throw new ComponentInitializationException("Trusted entity cannot be null");
        }
        if (this.trustMarkType == null) {
            throw new ComponentInitializationException("Trust mark type cannot be null");
        }
        if (this.subject == null) {
            throw new ComponentInitializationException("Subject cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, String> apply(@Nullable ProfileRequestContext profileRequestContext) {
        List cacheResult;
        this.checkComponentActive();
        String entityId = this.trustedEntity.getEntityId();
        URI uri = EntityStatementHelper.fetchEndpointUriFromFederationEntity(this.entityConfigurationCache, entityId, "trust_mark_endpoint", this.objectMapper);
        if (uri == null) {
            this.log.warn("Could not fetch trust mark endpoint for {}", (Object)entityId);
            return null;
        }
        TrustMarkRequest trustMarkRequest = new TrustMarkRequest(uri, this.trustMarkType, this.subject);
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new TrustMarkRequestCriterion(trustMarkRequest)});
        criteriaSet.add((Object)new ResponseContainerExpirationCriterion(Instant.now().plus(this.cachedLifetime)));
        try {
            cacheResult = this.trustMarkCache.get(criteriaSet);
        }
        catch (MetadataCacheException e) {
            this.log.warn("Could not resolve trust mark {} from {}", new Object[]{this.trustMarkType, this.trustedEntity, e});
            return null;
        }
        if (cacheResult.isEmpty()) {
            this.log.debug("No data resolved for {} from {}", (Object)this.trustMarkType, (Object)this.trustedEntity);
            return null;
        }
        Response response = ((TrustMarkResponseContainer)cacheResult.get(0)).getResponse();
        if (response instanceof TrustMarkResponse) {
            TrustMarkResponse successResponse = (TrustMarkResponse)response;
            return Map.of("trust_mark_type", this.trustMarkType, "trust_mark", successResponse.getJWT().serialize());
        }
        this.log.debug("The response from {} was not a success response: {}", (Object)this.trustedEntity, (Object)((TrustMarkResponseContainer)cacheResult.get(0)).getResponse());
        return null;
    }
}

