/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.EntityStatementHelper;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.TrustedRemoteResolverEntity;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultPreSelectedTrustChainIDsLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultTrustChainIDsLookupStrategy;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class CallResolveEntityApi
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(CallResolveEntityApi.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextCreationStrategy;
    @NonnullAfterInit
    private MetadataCache<EntityStatement> entityConfigurationCache;
    @NonnullAfterInit
    private MetadataCache<ResolveEntityResponseContainer> resolveEntityTrustChainMetadataCache;
    @NonnullAfterInit
    private Function<MessageContext, ClientID> clientIDLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> preSelectedTrustChainIdsLookupStrategy;
    @Nonnull
    private Function<List<EntityStatement>, List<String>> trustChainIDsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, EntityStatement> entityConfigurationLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> requireEntityConfigurationCondition;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<TrustedRemoteResolverEntity>> trustedEntitiesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> entityTypesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> cachedResponseLifetimeLookupStrategy;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @NonnullBeforeExec
    private String clientId;
    @NonnullBeforeExec
    private List<TrustedRemoteResolverEntity> trustedEntities;

    public CallResolveEntityApi() {
        Function tccs = new ChildContextLookup(RelyingPartyTrustChainContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (tccs != null);
        this.trustChainContextCreationStrategy = tccs;
        this.preSelectedTrustChainIdsLookupStrategy = new DefaultPreSelectedTrustChainIDsLookupStrategy();
        this.trustChainIDsLookupStrategy = new DefaultTrustChainIDsLookupStrategy();
        this.entityConfigurationLookupStrategy = FunctionSupport.constant(null);
        this.requireEntityConfigurationCondition = PredicateSupport.alwaysFalse();
        this.entityTypesLookupStrategy = FunctionSupport.constant(List.of("openid_relying_party"));
        this.cachedResponseLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(5L));
    }

    public void setTrustChainContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextCreationStrategy cannot be null");
    }

    public void setEntityConfigurationCache(@Nonnull MetadataCache<EntityStatement> cache) {
        this.checkSetterPreconditions();
        this.entityConfigurationCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Entity Configuration cache cannot be null");
    }

    public void setResolveEntityTrustChainMetadataCache(@Nonnull MetadataCache<ResolveEntityResponseContainer> cache) {
        this.checkSetterPreconditions();
        this.resolveEntityTrustChainMetadataCache = (MetadataCache)Constraint.isNotNull(cache, (String)"ResolveEntityTrustChainMetadataCache cannot be null");
    }

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.checkSetterPreconditions();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy cannot be null");
    }

    public void setPreSelectedTrustChainIdsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.preSelectedTrustChainIdsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"PreSelectedTrustChainIdsLookupStrategy cannot be null");
    }

    public void setTrustChainIDsLookupStrategy(@Nonnull Function<List<EntityStatement>, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.trustChainIDsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainIDsLookupStrategy cannot be null");
    }

    public void setEntityConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, EntityStatement> strategy) {
        this.checkSetterPreconditions();
        this.entityConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EntityConfigurationLookupStrategy cannot be null");
    }

    public void setRequireEntityConfigurationCondition(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.requireEntityConfigurationCondition = (Predicate)Constraint.isNotNull(predicate, (String)"RequireEntityConfigurationCondition cannot be null");
    }

    public void setTrustedEntitiesLookupStrategy(@Nonnull Function<ProfileRequestContext, List<TrustedRemoteResolverEntity>> strategy) {
        this.checkSetterPreconditions();
        this.trustedEntitiesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustedEntitiesLookupStrategy cannot be null");
    }

    public void setEntityTypesLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.entityTypesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EntityTypesLookupStrategy cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setCachedResponseLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.cachedResponseLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.entityConfigurationCache == null) {
            throw new ComponentInitializationException("Entity Configuration cache cannot be null");
        }
        if (this.resolveEntityTrustChainMetadataCache == null) {
            throw new ComponentInitializationException("ResolveEntityTrustChainMetadataCache cannot be null");
        }
        if (this.clientIDLookupStrategy == null) {
            throw new ComponentInitializationException("ClientIDLookupStrategy cannot be null");
        }
        if (this.trustedEntitiesLookupStrategy == null) {
            throw new ComponentInitializationException("TrustedEntitiesLookupStrategy cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        ClientID id = this.clientIDLookupStrategy.apply(profileRequestContext.getInboundMessageContext());
        if (id == null) {
            this.log.error("{} Unable to obtain client ID", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.clientId = id.getValue();
        try {
            new URL(this.clientId).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.log.debug("{} The client ID {} is not a valid URL, nothing to do", (Object)this.getLogPrefix(), (Object)this.clientId);
            return false;
        }
        this.trustedEntities = this.trustedEntitiesLookupStrategy.apply(profileRequestContext);
        if (this.trustedEntities == null || this.trustedEntities.isEmpty()) {
            this.log.warn("{} No trusted entities resolved for {} nothing to do", (Object)this.getLogPrefix(), (Object)this.clientId);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Resolving trust chain via resolve entity API for {}", (Object)this.getLogPrefix(), (Object)this.clientId);
        assert (this.clientId != null);
        CriteriaSet baseCriteriaSet = new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(this.clientId)});
        EntityStatement entityConfiguration = this.entityConfigurationLookupStrategy.apply(profileRequestContext);
        if (entityConfiguration != null) {
            this.log.debug("{} Entity configuration resolved and included to the criteria set", (Object)this.getLogPrefix());
            baseCriteriaSet.add((Object)new SubjectEntityStatementCriterion(entityConfiguration));
        } else if (this.requireEntityConfigurationCondition.test(profileRequestContext)) {
            this.log.error("{} Mandatory entity configuration could not be resolved", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        Duration cachedLifetime = this.cachedResponseLifetimeLookupStrategy.apply(profileRequestContext);
        if (cachedLifetime == null) {
            this.log.warn("{} Could not resolve lifetime for success responses", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        baseCriteriaSet.add((Object)new ResponseContainerExpirationCriterion(Instant.now().plus(cachedLifetime)));
        List<String> preSelectedChain = Optional.ofNullable(this.preSelectedTrustChainIdsLookupStrategy.apply(profileRequestContext)).orElse(CollectionSupport.emptyList());
        RelyingPartyTrustChainContext trustChainContext = this.trustChainContextCreationStrategy.apply(profileRequestContext);
        for (TrustedRemoteResolverEntity trustedEntity : this.trustedEntities) {
            List cacheResult;
            if (trustedEntity == null) {
                this.log.warn("{} Ignoring null trusted entity entry", (Object)this.getLogPrefix());
                continue;
            }
            List alreadyAttemptedEntities = Optional.ofNullable(trustChainContext.getAttemptedTrustedRemoteResolverEntities()).map(list -> new ArrayList(list)).orElseGet((Supplier<ArrayList>)NonnullSupplier.of(new ArrayList()));
            if (alreadyAttemptedEntities.contains(trustedEntity)) {
                this.log.debug("{} Trusted entity {} has already been attempted", (Object)this.getLogPrefix(), (Object)trustedEntity);
                continue;
            }
            alreadyAttemptedEntities.add(trustedEntity);
            trustChainContext.setAttemptedTrustedRemoteResolverEntities(CollectionSupport.copyToList((Collection)alreadyAttemptedEntities));
            URI uri = EntityStatementHelper.fetchEndpointUriFromFederationEntity(this.entityConfigurationCache, trustedEntity.getEntityId(), "federation_resolve_endpoint", this.objectMapper);
            if (uri == null) {
                this.log.warn("{} Could not fetch federation resolve endpoint for {}", (Object)this.getLogPrefix(), (Object)trustedEntity);
                continue;
            }
            ResolveEntityRequest entityRequest = new ResolveEntityRequest(uri, this.clientId, List.copyOf(trustedEntity.getTrustAnchors()), List.of("openid_relying_party"));
            CriteriaSet criteriaSet = new CriteriaSet();
            baseCriteriaSet.forEach(c -> criteriaSet.add(c));
            criteriaSet.add((Object)new ResolveEntityRequestCriterion(entityRequest));
            try {
                cacheResult = this.resolveEntityTrustChainMetadataCache.get(criteriaSet);
            }
            catch (MetadataCacheException e) {
                this.log.warn("{} Could not resolve entity for {} from {}", new Object[]{this.getLogPrefix(), this.clientId, trustedEntity, e});
                continue;
            }
            if (cacheResult.isEmpty()) {
                this.log.debug("{} No data resolved for {} from {}", new Object[]{this.getLogPrefix(), this.clientId, trustedEntity});
                continue;
            }
            Response response = ((ResolveEntityResponseContainer)cacheResult.get(0)).getResponse();
            if (response instanceof ResolveEntityResponse) {
                List<SignedJWT> trustMarks;
                List rawTrustMarks;
                Map rawMetadata;
                List rawTrustChain;
                ResolveEntityResponse successResponse = (ResolveEntityResponse)response;
                try {
                    rawTrustChain = successResponse.getJWT().getJWTClaimsSet().getStringListClaim("trust_chain");
                    rawMetadata = successResponse.getJWT().getJWTClaimsSet().getJSONObjectClaim("metadata");
                    rawTrustMarks = successResponse.getJWT().getJWTClaimsSet().getListClaim("trust_marks");
                }
                catch (ParseException e) {
                    this.log.error("{} Could not parse resolve entity response contents from {}", new Object[]{this.getLogPrefix(), trustedEntity, e});
                    continue;
                }
                if (rawTrustChain == null || rawTrustChain.isEmpty() || rawMetadata == null || rawMetadata.isEmpty()) {
                    this.log.warn("{} Could not parse mandatory parameters from the response from {}", (Object)this.getLogPrefix(), (Object)trustedEntity);
                    continue;
                }
                List<EntityStatement> chain = rawTrustChain.stream().filter(Objects::nonNull).map(entry -> EntityStatementHelper.deserializeEntityStatement(entry)).toList();
                if (!preSelectedChain.isEmpty() && !preSelectedChain.equals(this.trustChainIDsLookupStrategy.apply(chain))) {
                    this.log.debug("{} Ignored resolved trust chain that doesn't match with preselected chain", (Object)this.getLogPrefix());
                    continue;
                }
                Map<String, Map> metadata = rawMetadata.entrySet().stream().filter(entry -> entry.getKey() instanceof String && entry.getValue() instanceof Map).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((Map)entry.getValue()).entrySet().stream().filter(e -> e.getKey() instanceof String).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()))));
                ArrayList<Pair> policyCompliantChains = new ArrayList<Pair>();
                policyCompliantChains.add(new Pair(chain, metadata));
                trustChainContext.setPolicyCompliantTrustChains(policyCompliantChains);
                this.log.debug("{} Populated policy compliant trust chains with {}", (Object)this.getLogPrefix(), policyCompliantChains);
                List<SignedJWT> list2 = trustMarks = rawTrustMarks == null ? null : rawTrustMarks.stream().filter(Map.class::isInstance).map(Map.class::cast).map(map -> this.parseTrustMark(map.get("trust_mark"))).filter(Objects::nonNull).toList();
                if (trustMarks != null) {
                    HashMap<String, List<SignedJWT>> trustMarksByEntity = new HashMap<String, List<SignedJWT>>();
                    for (String entity2 : chain.stream().map(entity -> entity.getEntityID().getValue()).toList()) {
                        List<SignedJWT> trustMarksForEntity = trustMarks.stream().filter(jwt -> {
                            try {
                                return entity2.equals(jwt.getJWTClaimsSet().getSubject());
                            }
                            catch (ParseException e1) {
                                return false;
                            }
                        }).toList();
                        if (trustMarksForEntity.isEmpty()) continue;
                        trustMarksByEntity.put(entity2, trustMarksForEntity);
                    }
                    if (!trustMarksByEntity.isEmpty()) {
                        trustChainContext.setVerifiedTrustMarks(trustMarksByEntity);
                        Map<String, List> trustMarkIds = trustMarksByEntity.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).stream().map(jwt -> {
                            try {
                                return jwt.getJWTClaimsSet().getStringClaim("trust_mark_type");
                            }
                            catch (ParseException e1) {
                                return null;
                            }
                        }).filter(Objects::nonNull).toList()));
                        this.log.debug("{} The following trust marks are included: {}", (Object)this.getLogPrefix(), trustMarkIds);
                        trustChainContext.setVerifiedTrustMarkIds(trustMarkIds);
                    }
                } else {
                    this.log.debug("{} No trust marks included in the response from {}", (Object)this.getLogPrefix(), (Object)trustedEntity);
                }
                return;
            }
            this.log.debug("{} The response from {} was not a success response: {}", new Object[]{this.getLogPrefix(), trustedEntity, ((ResolveEntityResponseContainer)cacheResult.get(0)).getResponse()});
        }
        this.log.debug("{} No previously not attempted policy-compliant trust chains resolved", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"CheckFallback");
    }

    @Nullable
    private SignedJWT parseTrustMark(@Nullable Object trustMark) {
        if (trustMark instanceof String) {
            String string = (String)trustMark;
            try {
                return SignedJWT.parse((String)string);
            }
            catch (ParseException e) {
                this.log.error("{} Could not parse the trust mark into a JWT", (Object)this.getLogPrefix(), (Object)e);
            }
        }
        return null;
    }
}

