/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.RelyingPartyTrustChainContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.AbstractBuildEntityStatementAction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.DefaultEntityTypesLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class BuildResolveEntityResponse
extends AbstractBuildEntityStatementAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildResolveEntityResponse.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> entityTypesLookupStrategy;
    @NonnullBeforeExec
    private RelyingPartyTrustChainContext trustChainContext;

    public BuildResolveEntityResponse() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
        this.entityTypesLookupStrategy = new DefaultEntityTypesLookupFunction();
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    public void setEntityTypesLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.entityTypesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EntityTypesLookupStrategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.trustChainContext = this.trustChainContextLookupStrategy.apply(profileRequestContext);
        if (this.trustChainContext == null) {
            this.log.error("{} Unable to locate trust chain context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Override
    protected boolean populateClaimsSetBuilder(@Nonnull JWTClaimsSet.Builder builder, @Nonnull ProfileRequestContext profileRequestContext) {
        Pair selectedTrustChain = this.trustChainContext.getSelectedTrustChain();
        if (selectedTrustChain == null) {
            this.log.debug("{} No selected trust chain found form the context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMetadata");
            return false;
        }
        Map metadata = (Map)selectedTrustChain.getSecond();
        if (metadata == null) {
            this.log.debug("{} No metadata set for the selected trust chain", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMetadata");
            return false;
        }
        List<String> entityTypes = this.entityTypesLookupStrategy.apply(profileRequestContext);
        this.log.trace("{} The following entity types were requested: {}", (Object)this.getLogPrefix(), entityTypes);
        if (entityTypes != null && !entityTypes.isEmpty()) {
            Map<String, Object> filteredMetadata = metadata.entrySet().stream().filter(entry -> entityTypes.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (filteredMetadata.isEmpty()) {
                this.log.warn("{} No metadata for entity types {} found for the selected trust chain", (Object)this.getLogPrefix(), entityTypes);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMetadata");
                return false;
            }
            builder.claim("metadata", filteredMetadata);
        } else {
            builder.claim("metadata", (Object)metadata);
        }
        List trustChain = (List)selectedTrustChain.getFirst();
        if (trustChain == null || trustChain.isEmpty()) {
            this.log.debug("{} No selected trust chain set in the trust chain context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMetadata");
            return false;
        }
        builder.claim("trust_chain", trustChain.stream().map(statement -> statement.getSignedStatement().serialize()).toList());
        Instant expirationTime = this.resolveTrustChainExpiration(trustChain);
        if (expirationTime == null) {
            this.log.error("{} Coud not resolve expiration time from the selected trust chain context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        builder.expirationTime(Date.from(expirationTime));
        String entityId = ((EntityStatement)trustChain.get(0)).getEntityID().getValue();
        assert (entityId != null);
        Map<String, String> trustMarks = this.buildTrustMarks(entityId, this.trustChainContext.getVerifiedTrustMarks());
        if (trustMarks != null && !trustMarks.isEmpty()) {
            builder.claim("trust_marks", trustMarks);
        }
        return true;
    }

    @Nullable
    private Map<String, String> buildTrustMarks(@Nonnull String entityId, @Nullable Map<String, List<SignedJWT>> trustMarks) {
        return Optional.ofNullable(trustMarks).map(marks -> (List)marks.get(entityId)).filter(Objects::nonNull).map(list -> list.stream().map(trustMark -> new Pair((Object)this.getTrustMarkId((SignedJWT)trustMark), (Object)trustMark.serialize())).filter(Objects::nonNull).collect(Collectors.toMap(pair -> (String)pair.getFirst(), pair -> (String)pair.getSecond()))).orElse(null);
    }

    @Nullable
    private String getTrustMarkId(@Nullable SignedJWT trustMark) {
        try {
            return trustMark == null ? null : trustMark.getJWTClaimsSet().getStringClaim("trust_mark_type");
        }
        catch (ParseException e) {
            this.log.error("{} Could not parse the TrustMark JWT contents", (Object)this.getLogPrefix(), (Object)e);
            return null;
        }
    }

    @Nullable
    private Instant resolveTrustChainExpiration(@Nonnull List<EntityStatement> trustChain) {
        Instant metadataExpiration = null;
        for (EntityStatement statement : trustChain) {
            Instant statementExpiration = statement.getClaimsSet().getExpirationTime().toInstant();
            metadataExpiration = metadataExpiration == null ? statementExpiration : (statementExpiration.isBefore(metadataExpiration) ? statementExpiration : metadataExpiration);
        }
        return metadataExpiration;
    }
}

