/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.context.RelyingPartyTrustChainContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class AddExtensionsToClientInformation
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddExtensionsToClientInformation.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @NonnullBeforeExec
    private OIDCClientInformation clientInformation;
    @NonnullBeforeExec
    private RelyingPartyTrustChainContext trustChainContext;
    @NonnullBeforeExec
    private Pair<List<EntityStatement>, Map<String, Map<String, Object>>> selectedTrustChain;

    public AddExtensionsToClientInformation() {
        Function orcls = new ChildContextLookup(OIDCClientRegistrationResponseContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (orcls != null);
        this.oidcResponseContextLookupStrategy = orcls;
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCClientRegistrationResponseContext oidcResponseCtx = this.oidcResponseContextLookupStrategy.apply(profileRequestContext);
        if (oidcResponseCtx == null || oidcResponseCtx.getClientInformation() == null) {
            this.log.debug("{} No OIDC client informationt could be resolved with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.clientInformation = oidcResponseCtx.getClientInformation();
        this.trustChainContext = this.trustChainContextLookupStrategy.apply(profileRequestContext);
        if (this.trustChainContext == null || this.trustChainContext.getSelectedTrustChain() == null) {
            this.log.error("{} Unable to locate selected trust chain", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.selectedTrustChain = this.trustChainContext.getSelectedTrustChain();
        assert (this.selectedTrustChain != null);
        if (this.selectedTrustChain.getFirst() == null || this.selectedTrustChain.getSecond() == null) {
            this.log.error("{} Selected trust chain contents is not populated", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        List trustChain = (List)this.selectedTrustChain.getFirst();
        assert (trustChain != null);
        this.clientInformation.getOIDCMetadata().setCustomField("oidfed_validated_trust_anchor", (Object)((EntityStatement)trustChain.get(trustChain.size() - 1)).getEntityID().getValue());
        this.clientInformation.getOIDCMetadata().setCustomField("oidfed_validated_trust_chain", trustChain.stream().map(es -> es.getSignedStatement().serialize()).toList());
        Map verifiedTrustMarks = this.trustChainContext.getVerifiedTrustMarkIds();
        if (verifiedTrustMarks != null) {
            this.clientInformation.getOIDCMetadata().setCustomField("oidfed_validated_trust_mark_ids", (Object)verifiedTrustMarks);
        }
    }
}

