/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.OIDFederationExplicitRegistrationProfileConfiguration;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.impl.AbstractOIDFederationRegistrationProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOIDFederationExplicitRegistrationProfileConfiguration
extends AbstractOIDFederationRegistrationProfileConfiguration
implements OIDFederationExplicitRegistrationProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oidfed.explicitregistration";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> authorizationCodeFlowPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> implicitFlowPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> refreshTokensPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> tokenEndpointAuthMethodsLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.setOf((Object[])new String[]{ClientAuthenticationMethod.CLIENT_SECRET_BASIC.toString(), ClientAuthenticationMethod.CLIENT_SECRET_POST.toString(), ClientAuthenticationMethod.CLIENT_SECRET_JWT.toString(), ClientAuthenticationMethod.PRIVATE_KEY_JWT.toString()}));
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> entityStatementClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);

    public DefaultOIDFederationExplicitRegistrationProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/oidfed/explicitregistration");
    }

    public DefaultOIDFederationExplicitRegistrationProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public boolean isAuthorizationCodeFlowEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authorizationCodeFlowPredicate.test(profileRequestContext);
    }

    public void setAuthorizationCodeFlowEnabled(boolean flag) {
        this.authorizationCodeFlowPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setAuthorizationCodeFlowEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.authorizationCodeFlowPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether authorization code flow is supported cannot be null");
    }

    public boolean isImplicitFlowEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.implicitFlowPredicate.test(profileRequestContext);
    }

    public void setImplicitFlowEnabled(boolean flag) {
        this.implicitFlowPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setImplicitFlowEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.implicitFlowPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether hybrid flow is supported cannot be null");
    }

    public boolean isRefreshTokensEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.refreshTokensPredicate.test(profileRequestContext);
    }

    public void setRefreshTokensEnabled(boolean flag) {
        this.refreshTokensPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setRefreshTokensEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.refreshTokensPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether refresh tokens are supported cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getTokenEndpointAuthMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection methods = this.tokenEndpointAuthMethodsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return CollectionSupport.copyToSet((Collection)methods);
        }
        return CollectionSupport.emptySet();
    }

    public void setTokenEndpointAuthMethods(@Nonnull @NonnullElements Collection<String> methods) {
        Constraint.isNotNull(methods, (String)"Collection of methods cannot be null");
        this.tokenEndpointAuthMethodsLookupStrategy = FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(methods)));
    }

    public void setTokenEndpointAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.tokenEndpointAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getEntityStatementClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.entityStatementClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setEntityStatementClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.entityStatementClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setEntityStatementClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.entityStatementClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

