/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.impl;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.OIDFederationEntityConfigurationProfileConfiguration;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.impl.AbstractOIDFederationResponseCachingProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOIDFederationEntityConfigurationProfileConfiguration
extends AbstractOIDFederationResponseCachingProfileConfiguration
implements OIDFederationEntityConfigurationProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oidfed.configuration";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, List<String>> authorityHintsLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptyList());
    @Nonnull
    private Function<ProfileRequestContext, Duration> entityStatementLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(24L));
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> entityStatementClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Map<String, Function<ProfileRequestContext, Object>>> optionalClaimsLookupStrategiesLookupStrategy = FunctionSupport.constant(null);

    public DefaultOIDFederationEntityConfigurationProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/oidfed/configuration");
    }

    public DefaultOIDFederationEntityConfigurationProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getAuthorityHints(@Nullable ProfileRequestContext profileRequestContext) {
        List<String> authorityHints = this.authorityHintsLookupStrategy.apply(profileRequestContext);
        if (authorityHints != null) {
            return CollectionSupport.copyToList(authorityHints);
        }
        return CollectionSupport.emptyList();
    }

    public void setAuthorityHints(@Nonnull @NonnullElements @NotLive @Unmodifiable List<String> hints) {
        this.authorityHintsLookupStrategy = FunctionSupport.constant(hints);
    }

    public void setAuthorityHintsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.authorityHintsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authority hints lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getEntityStatementLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.entityStatementLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Entity statement lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setEntityStatementLifetime(@Nonnull @Positive Duration lifetime) {
        Duration statementLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Entity statement lifetime cannot be null");
        Constraint.isTrue((!statementLifetime.isZero() && !statementLifetime.isNegative() ? 1 : 0) != 0, (String)"Entity statement lifetime must be greater than 0");
        this.entityStatementLifetimeLookupStrategy = FunctionSupport.constant((Object)statementLifetime);
    }

    public void setEntityStatementLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.entityStatementLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getEntityStatementClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.entityStatementClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setEntityStatementClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.entityStatementClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setEntityStatementClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.entityStatementClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Map<String, Function<ProfileRequestContext, Object>> getOptionalClaimsLookupStrategies(@Nullable ProfileRequestContext profileRequestContext) {
        return this.optionalClaimsLookupStrategiesLookupStrategy.apply(profileRequestContext);
    }

    public void setOptionalClaimsLookupStrategies(@Nullable Map<String, Function<ProfileRequestContext, Object>> strategies) {
        this.optionalClaimsLookupStrategiesLookupStrategy = FunctionSupport.constant(strategies);
    }

    public void setOptionalClaimsLookupStrategiesLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, Function<ProfileRequestContext, Object>>> strategy) {
        this.optionalClaimsLookupStrategiesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

