/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.impl;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.config.OIDFederationRegistrationProfileConfiguration;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class AbstractOIDFederationRegistrationProfileConfiguration
extends AbstractConditionalProfileConfiguration
implements OIDFederationRegistrationProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> localMetadataPolicyLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptyMap());
    @Nonnull
    private Function<ProfileRequestContext, List<String>> mandatoryTrustMarksLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptyList());
    @Nonnull
    private Function<ProfileRequestContext, Duration> maximumTrustMarkLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofDays(365L));

    public AbstractOIDFederationRegistrationProfileConfiguration(@Nonnull @ParameterName(name="id") @NotEmpty String id) {
        super(id);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<String, MetadataPolicy> getLocalMetadataPolicy(@Nullable ProfileRequestContext profileRequestContext) {
        Map<String, MetadataPolicy> policy = this.localMetadataPolicyLookupStrategy.apply(profileRequestContext);
        if (policy != null) {
            return CollectionSupport.copyToMap(policy);
        }
        return CollectionSupport.emptyMap();
    }

    public void setLocalMetadataPolicy(@Nonnull @NonnullElements @NotLive @Unmodifiable Map<String, MetadataPolicy> policy) {
        this.localMetadataPolicyLookupStrategy = FunctionSupport.constant(policy);
    }

    public void setLocalMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        this.localMetadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Local metadata policy lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getMandatoryTrustMarks(@Nullable ProfileRequestContext profileRequestContext) {
        List<String> trustMarks = this.mandatoryTrustMarksLookupStrategy.apply(profileRequestContext);
        if (trustMarks != null) {
            return CollectionSupport.copyToList(trustMarks);
        }
        return CollectionSupport.emptyList();
    }

    public void setMandatoryTrustMarks(@Nonnull @NonnullElements @NotLive @Unmodifiable List<String> marks) {
        this.mandatoryTrustMarksLookupStrategy = FunctionSupport.constant(marks);
    }

    public void setMandatoryTrustMarksLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.mandatoryTrustMarksLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Mandatory trust marks lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getMaximumTrustMarkLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.maximumTrustMarkLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Maximum trust mark lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setMaximumTrustMarkLifetime(@Nonnull @Positive Duration lifetime) {
        Duration trustMarkLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Maximum trust mark lifetime cannot be null");
        Constraint.isTrue((!trustMarkLifetime.isZero() && !trustMarkLifetime.isNegative() ? 1 : 0) != 0, (String)"Maximum trust mark lifetime must be greater than 0");
        this.maximumTrustMarkLifetimeLookupStrategy = FunctionSupport.constant((Object)trustMarkLifetime);
    }

    public void setMaximumTrustMarkLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.maximumTrustMarkLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

