/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl.AbstractFederationMetadataPolicyOperator;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultFederationMetadataPolicySupersetOfOperator
extends AbstractFederationMetadataPolicyOperator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFederationMetadataPolicySupersetOfOperator.class);

    @Override
    @Nullable
    public Object apply(@Nullable Object candidate, @Nonnull MetadataPolicy policy) throws ConstraintViolationException {
        List supersetOf = policy.getSupersetOfValues();
        if (candidate == null || supersetOf == null) {
            return candidate;
        }
        if (!(candidate instanceof List)) {
            this.log.warn("The value for superset_of is not a list/array {}", candidate);
            throw new ConstraintViolationException("Candidate value " + String.valueOf(candidate) + " is not a list/array");
        }
        List list = (List)candidate;
        List<Object> candidateList = list.stream().filter(Object.class::isInstance).map(Object.class::cast).toList();
        assert (candidateList != null);
        if (!candidateList.containsAll(supersetOf)) {
            this.log.debug("The candidate {} did not contain all the values of superset_of: {}", candidate, (Object)supersetOf);
            throw new ConstraintViolationException("Candidate value " + String.valueOf(candidate) + " did not contain all values of superset_of: " + String.valueOf(supersetOf));
        }
        return CollectionSupport.copyToList(candidateList);
    }

    @Override
    public boolean validate(@Nonnull MetadataPolicy policy) {
        List subsetOf;
        List supersetOf = policy.getSupersetOfValues();
        if (supersetOf == null) {
            return true;
        }
        boolean validation = true;
        Object value = policy.getValue();
        if (value != null && !MetadataPolicyHelper.isSupersetOfValues((Object)value, (Collection)supersetOf)) {
            this.log.debug("The value {} is not a superset of the values for subset_of operator {}", value, (Object)supersetOf);
            validation = false;
        }
        if ((subsetOf = policy.getSubsetOfValues()) != null && !MetadataPolicyHelper.isSupersetOfValues((Object)subsetOf, (Collection)supersetOf)) {
            this.log.debug("The value for subset_of operator {} is not a superset of the values for superset_of operator {}", (Object)subsetOf, (Object)supersetOf);
            validation = false;
        }
        return validation;
    }
}

