/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl.AbstractFederationMetadataPolicyOperator;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultFederationMetadataPolicySubsetOfOperator
extends AbstractFederationMetadataPolicyOperator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFederationMetadataPolicySubsetOfOperator.class);

    @Override
    @Nullable
    public Object apply(@Nullable Object candidate, @Nonnull MetadataPolicy policy) throws ConstraintViolationException {
        List subsetOf = policy.getSubsetOfValues();
        if (candidate == null || subsetOf == null) {
            this.log.debug("No candidate or subset_of value present. nothing to do");
            return candidate;
        }
        if (candidate instanceof List) {
            List list = (List)candidate;
            List<Object> candidateList = list.stream().filter(Object.class::isInstance).map(Object.class::cast).filter(item -> subsetOf.contains(item)).toList();
            assert (candidateList != null);
            return CollectionSupport.copyToList(candidateList);
        }
        this.log.debug("Candidate value {} is not a list/array", candidate);
        throw new ConstraintViolationException("Candidate value " + String.valueOf(candidate) + " is not a list/array");
    }

    @Override
    public boolean validate(@Nonnull MetadataPolicy policy) {
        List supersetOf;
        Object add;
        List subsetOf = policy.getSubsetOfValues();
        if (subsetOf == null) {
            return true;
        }
        boolean validation = true;
        Object value = policy.getValue();
        if (value != null && !MetadataPolicyHelper.isSubsetOfValues((Object)value, (Collection)subsetOf)) {
            this.log.debug("The value {} is not a subset of the values for subset_of operator {}", value, (Object)subsetOf);
            validation = false;
        }
        if ((add = policy.getAdd()) != null && !MetadataPolicyHelper.isSubsetOfValues((Object)add, (Collection)subsetOf)) {
            this.log.debug("The value for add operator {} is not a subset of the values for subset_of operator {}", add, (Object)subsetOf);
            validation = false;
        }
        if ((supersetOf = policy.getSupersetOfValues()) != null && !MetadataPolicyHelper.isSupersetOfValues((Object)subsetOf, (Collection)supersetOf)) {
            this.log.debug("The value for subset_of operator {} is not a subset of the values for superset_of operator {}", (Object)subsetOf, (Object)supersetOf);
            validation = false;
        }
        return validation;
    }
}

